/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.liveontologies.protege.explanation.proof.OWLRenderer;
import org.liveontologies.protege.explanation.proof.ProofManager;
import org.liveontologies.protege.explanation.proof.editing.OWLAxiomChecker;
import org.liveontologies.protege.explanation.proof.editing.OWLAxiomEditor;
import org.liveontologies.protege.explanation.proof.list.InferenceSection;
import org.liveontologies.protege.explanation.proof.list.ProofRoot;
import org.liveontologies.protege.explanation.proof.preferences.ProofBasedExplPrefs;
import org.liveontologies.puli.ProofNode;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameListener;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofFrame
implements OWLFrame<ProofRoot> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ProofFrame.class);
    private final ProofManager man_;
    private final OWLEditorKit kit_;
    private final OWLRenderer renderer_;
    private final OWLAxiomChecker checker_;
    private final OWLObjectEditor<OWLAxiom> editor_;
    private ProofRoot root_;
    private InferenceSection rootSection_;
    private final List<OWLFrameListener> listeners_ = new ArrayList<OWLFrameListener>(2);
    private final int displayedInferencesPerConclusionLimit_;

    public ProofFrame(ProofManager man, final OWLEditorKit kit) {
        this.man_ = man;
        this.kit_ = kit;
        this.renderer_ = new OWLRenderer(){

            @Override
            public String render(OWLObject obj) {
                return kit.getOWLModelManager().getRendering(obj);
            }
        };
        this.checker_ = new OWLAxiomChecker(this.kit_.getModelManager());
        this.editor_ = new OWLAxiomEditor(this.kit_, this.checker_);
        this.displayedInferencesPerConclusionLimit_ = ProofBasedExplPrefs.create().load().displayedInferencesPerConclusionLimit;
        this.updateProof();
    }

    ProofManager getWorkbenchManager() {
        return this.man_;
    }

    OWLAxiomChecker getAxiomChecker() {
        return this.checker_;
    }

    OWLEditorKit getEditorKit() {
        return this.kit_;
    }

    OWLRenderer getRenderer() {
        return this.renderer_;
    }

    OWLObjectEditor<OWLAxiom> getAxiomEditor() {
        return this.editor_;
    }

    InferenceSection getRootSection() {
        if (this.rootSection_ == null) {
            this.rootSection_ = new InferenceSection(this, this.root_);
        }
        return this.rootSection_;
    }

    int getDisplayedInferencesPerConclusionLimit() {
        return this.displayedInferencesPerConclusionLimit_;
    }

    public void updateProof() {
        ProofNode<OWLAxiom> newProof = this.man_.getProofRoot();
        this.setRootObject(new ProofRoot(this.man_.getEntailment(), newProof == null ? Collections.emptyList() : Collections.singletonList(newProof), this.renderer_));
    }

    public void dispose() {
        if (this.rootSection_ != null) {
            this.rootSection_.dispose();
        }
        this.editor_.dispose();
    }

    public void setRootObject(ProofRoot newRoot) {
        if (this.root_ == newRoot) {
            return;
        }
        this.root_ = newRoot;
        InferenceSection previousRootSection = this.rootSection_;
        this.rootSection_ = null;
        if (previousRootSection != null) {
            this.getRootSection().getRow().copySettingsFrom(previousRootSection.getRow());
            previousRootSection.dispose();
        }
        this.fireContentChanged();
    }

    public ProofRoot getRootObject() {
        return this.root_;
    }

    public List<OWLFrameSection> getFrameSections() {
        return Collections.singletonList(this.getRootSection());
    }

    public synchronized void addFrameListener(OWLFrameListener listener) {
        this.listeners_.add(listener);
    }

    public synchronized void removeFrameListener(OWLFrameListener listener) {
        this.listeners_.remove(listener);
    }

    public synchronized void fireContentChanged() {
        int i;
        try {
            for (i = 0; i < this.listeners_.size(); ++i) {
                this.listeners_.get(i).frameContentChanged();
            }
        }
        catch (Throwable e) {
            LOGGER_.warn("Remove the listener due to an exception", e);
            this.removeFrameListener(this.listeners_.get(i));
        }
    }
}

