/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ListUI;
import org.liveontologies.protege.explanation.proof.list.ConclusionSection;
import org.liveontologies.protege.explanation.proof.list.InferenceRow;
import org.liveontologies.protege.explanation.proof.list.MoreInferencesButton;
import org.liveontologies.protege.explanation.proof.list.MoreInferencesRow;
import org.liveontologies.protege.explanation.proof.list.NavButton;
import org.liveontologies.protege.explanation.proof.list.ProofFrame;
import org.liveontologies.protege.explanation.proof.list.ProofFrameListRenderer;
import org.liveontologies.protege.explanation.proof.list.ProofFrameListRow;
import org.liveontologies.protege.explanation.proof.list.ProofRoot;
import org.liveontologies.protege.explanation.proof.preferences.ProofBasedExplPrefs;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameListener;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.framelist.OWLFrameListInferredSectionRowBorder;

public class ProofFrameList
extends OWLFrameList<ProofRoot> {
    public static final Border INFERRED_BORDER = new OWLFrameListInferredSectionRowBorder();
    public static final Color HIGHLIGHT_COLOR = new Color(230, 215, 246);
    public static final int LONG_PRESS_THRESHOLD = 500;
    private static final String NAV_CLICK = "Navigation Click";
    private static final String NAV_ALT_CLICK = "Navigation Button Click";
    private static final String NAV_LONG_PRESS = "Navigation Button Long Press";
    private static final String ACTION_EXPAND_ROW = "Expand Row";
    private static final String ACTION_COLLAPSE_ROW = "Collapse Row";
    private static final String ACTION_ENTER_ROW = "Toggle Expand Row";
    public static final BasicStroke DASH = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);
    public static Icon TREE_EXPANDED;
    public static Icon TREE_COLLAPSED;
    public static int LEFT_CHILD_INDENT;
    public static int RIGHT_CHILD_INDENT;
    public static final int INFERENCE_INDENT = 4;
    public static boolean PAINT_LINES;
    public static boolean LINE_TYPE_DASHED;
    public static Color LINE;
    private final NavButton navButton_;
    private final MListButton moreInferencesButton_;
    private final int recursiveExpansionLimit_;

    public ProofFrameList(OWLEditorKit editorKit, ProofFrame proofFrame) {
        super(editorKit, (OWLFrame)proofFrame);
        ProofFrameList.initNavigationProperties();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProofFrameList.initNavigationProperties();
            }
        });
        this.navButton_ = new NavButton((Component)((Object)this));
        this.moreInferencesButton_ = new MoreInferencesButton();
        this.recursiveExpansionLimit_ = ProofBasedExplPrefs.create().load().recursiveExpansionLimit;
        this.setModel(new ProofFrameListModel(proofFrame));
        this.setUI((ListUI)((Object)new ProofFrameListUI()));
        this.setCellRenderer(new ProofFrameListRenderer(editorKit));
        this.getSelectionModel().setSelectionMode(0);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ProofFrameList.this.getProofListModel().setHighlightsFor(ProofFrameList.this.getSelectedIndex());
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), ACTION_EXPAND_ROW);
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), ACTION_COLLAPSE_ROW);
        this.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), ACTION_ENTER_ROW);
        this.getActionMap().put(ACTION_EXPAND_ROW, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofFrameListRow row = ProofFrameList.this.getSelectedValue();
                if (row == null) {
                    return;
                }
                if (!row.isExpanded()) {
                    ProofFrameList.this.toggleExpandState(row);
                }
                ProofFrameList.this.ensureIndexIsVisible(ProofFrameList.this.getSelectedIndex());
            }
        });
        this.getActionMap().put(ACTION_COLLAPSE_ROW, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofFrameListRow row = ProofFrameList.this.getSelectedValue();
                if (row == null) {
                    return;
                }
                if (row.isExpanded() && row.isExpandable()) {
                    ProofFrameList.this.toggleExpandState(row);
                } else {
                    ProofFrameListRow parent = row.getParent();
                    if (parent != null) {
                        int index = parent.getIndex();
                        ProofFrameList.this.setSelectedIndex(index);
                    }
                }
                ProofFrameList.this.ensureIndexIsVisible(ProofFrameList.this.getSelectedIndex());
            }
        });
        this.getActionMap().put(ACTION_ENTER_ROW, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofFrameList.this.handleEnterKey(ProofFrameList.this.getSelectedValue());
                ProofFrameList.this.ensureIndexIsVisible(ProofFrameList.this.getSelectedIndex());
            }
        });
        this.addMouseListener(new ProofFrameListMouseListener());
    }

    private static void initNavigationProperties() {
        TREE_EXPANDED = (Icon)UIManager.get("Tree.expandedIcon");
        TREE_COLLAPSED = (Icon)UIManager.get("Tree.collapsedIcon");
        LEFT_CHILD_INDENT = (Integer)UIManager.get("Tree.leftChildIndent");
        RIGHT_CHILD_INDENT = (Integer)UIManager.get("Tree.rightChildIndent");
        PAINT_LINES = UIManager.getBoolean("Tree.paintLines");
        LINE_TYPE_DASHED = UIManager.getBoolean("Tree.lineTypeDashed") || UIManager.getLookAndFeel().getClass().getName().equals("com.jgoodies.looks.plastic.PlasticLookAndFeel");
        LINE = UIManager.getColor("Tree.hash");
    }

    static int getRowIndent(ProofFrameListRow row) {
        return row.accept(new ProofFrameListRow.Visitor<Integer>(){

            int getInferenceIndent(ProofFrameListRow row) {
                return row.getRowDepth() * (LEFT_CHILD_INDENT + RIGHT_CHILD_INDENT + 4) / 2 + 4;
            }

            @Override
            public Integer visit(ConclusionSection row) {
                return (row.getRowDepth() + 1) * (LEFT_CHILD_INDENT + RIGHT_CHILD_INDENT + 4) / 2;
            }

            @Override
            public Integer visit(InferenceRow row) {
                return this.getInferenceIndent(row);
            }

            @Override
            public Integer visit(MoreInferencesRow row) {
                return this.getInferenceIndent(row);
            }
        }) - 4;
    }

    ProofFrameListModel getProofListModel() {
        return (ProofFrameListModel)super.getModel();
    }

    public void setListData(Object[] listData) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (newValue == oldValue) {
            return;
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void clearCellHeightCache() {
    }

    public void refreshComponent() {
    }

    public ProofFrameListRow getSelectedValue() {
        return (ProofFrameListRow)super.getSelectedValue();
    }

    public ProofFrame getFrame() {
        return (ProofFrame)super.getFrame();
    }

    public String getToolTipText(MouseEvent event) {
        if (event == null) {
            return super.getToolTipText();
        }
        Point location = event.getPoint();
        int index = this.locationToIndex(location);
        if (index < 0 || !this.getCellBound(index).contains(location)) {
            return super.getToolTipText();
        }
        ProofFrameListRow row = this.getProofListModel().getElementAt(index);
        if (row instanceof InferenceRow) {
            return row.getTooltip();
        }
        return super.getToolTipText(event);
    }

    protected void handleEnterKey(ProofFrameListRow row) {
        row.accept(new ProofFrameListRow.Visitor<Void>(){

            @Override
            public Void visit(InferenceRow row) {
                return null;
            }

            @Override
            public Void visit(ConclusionSection row) {
                if (row.isEditable()) {
                    ProofFrameList.this.handleEdit();
                } else {
                    ProofFrameList.this.toggleExpandState(row);
                }
                return null;
            }

            @Override
            public Void visit(MoreInferencesRow row) {
                ProofFrameList.this.getProofListModel().loadMoreInferences(row.getParent());
                return null;
            }
        });
    }

    protected void handleDoubleClick(ProofFrameListRow row) {
        ConclusionSection conclRow;
        if (row instanceof ConclusionSection && !(conclRow = (ConclusionSection)row).isEditable()) {
            this.toggleExpandState(conclRow);
        }
    }

    protected void toggleExpandState(ProofFrameListRow row) {
        this.getProofListModel().toggleExpandState(row);
    }

    protected void toggleExpandRecursive(ProofFrameListRow row) {
        this.getProofListModel().toggleExpandRecursive(row);
    }

    Rectangle getCellBound(int index) {
        Rectangle bounds = this.getCellBounds(index, index);
        if (bounds != null) {
            int oldX = bounds.x;
            bounds.x = ProofFrameList.getRowIndent(this.getProofListModel().getElementAt(index));
            bounds.width = bounds.width + oldX - bounds.x;
        }
        return bounds;
    }

    protected Border createPaddingBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE);
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof ConclusionSection) {
            ConclusionSection row = (ConclusionSection)value;
            Border internalPadding = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            MatteBorder line = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(240, 240, 240));
            MatteBorder externalBorder = BorderFactory.createMatteBorder(0, ProofFrameList.getRowIndent(row), 0, 0, list.getBackground());
            CompoundBorder border = BorderFactory.createCompoundBorder(externalBorder, BorderFactory.createCompoundBorder(line, internalPadding));
            if (row.isInferred()) {
                border = BorderFactory.createCompoundBorder(border, INFERRED_BORDER);
            }
            return border;
        }
        return super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
    }

    protected String getRowName(Object rowObject) {
        if (rowObject instanceof ConclusionSection) {
            ConclusionSection conclusionSection = (ConclusionSection)rowObject;
            if (conclusionSection.isAsserted()) {
                return "Asserted axiom";
            }
            return "Entailed axiom";
        }
        return super.getRowName(rowObject);
    }

    protected Color getItemBackgroundColor(MListItem item) {
        if (item instanceof ConclusionSection) {
            ConclusionSection exprRow = (ConclusionSection)item;
            if (exprRow.isHighlighted()) {
                return HIGHLIGHT_COLOR;
            }
            if (!exprRow.isAsserted()) {
                return INFERRED_BG_COLOR;
            }
        }
        return super.getItemBackgroundColor(item);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        if (PAINT_LINES) {
            if (LINE_TYPE_DASHED) {
                g2.setStroke(DASH);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setColor(LINE);
            this.paintLines(g2);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintNavButtons(g2);
        g.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    public void repaint() {
        super.repaint();
    }

    private void paintNavButtons(Graphics2D g2) {
        for (int index = 0; index < this.getModel().getSize(); ++index) {
            NavButton button = this.getNavButton(index);
            if (button == null || !button.getBounds().intersects(g2.getClipBounds())) continue;
            button.paintButtonContent(g2);
        }
    }

    private int getNavX(ProofFrameListRow row) {
        return ProofFrameList.getRowIndent(row) - RIGHT_CHILD_INDENT;
    }

    private int getNavY(ProofFrameListRow row) {
        int index = row.getIndex();
        Rectangle rowBounds = this.getCellBounds(index, index);
        return rowBounds.y + this.getButtonDimension() / 2 + 1;
    }

    private void paintLines(final Graphics2D g2) {
        int i = 0;
        while (i < this.getModel().getSize()) {
            final int index = i++;
            ProofFrameListRow row = this.getProofListModel().getElementAt(index);
            row.accept(new ProofFrameListRow.Visitor<Void>(){

                @Override
                public Void visit(InferenceRow row) {
                    if (!row.isExpanded() || row.getIndex() == 0) {
                        return null;
                    }
                    List children = row.getChildren();
                    int size = children.size();
                    if (size == 0) {
                        return null;
                    }
                    ProofFrameListRow lastChild = (ProofFrameListRow)children.get(size - 1);
                    int lastIndex = lastChild.getIndex();
                    Rectangle childBounds = ProofFrameList.this.getCellBounds(index + 1, lastIndex);
                    int x = ProofFrameList.this.getNavX(row) + LEFT_CHILD_INDENT + RIGHT_CHILD_INDENT;
                    int y1 = childBounds.y;
                    int y2 = ProofFrameList.this.getNavY(lastChild);
                    Rectangle clipBound = g2.getClipBounds();
                    if (clipBound.x <= x && x <= clipBound.x + clipBound.width && clipBound.y <= y2 && y1 <= clipBound.y + clipBound.height) {
                        g2.drawLine(x, y1, x, y2);
                    }
                    return null;
                }

                @Override
                public Void visit(ConclusionSection row) {
                    int x1 = ProofFrameList.this.getNavX(row);
                    int x2 = x1 + RIGHT_CHILD_INDENT - 1;
                    int y = ProofFrameList.this.getNavY(row);
                    Rectangle clipBound = g2.getClipBounds();
                    if (clipBound.x <= x2 && x1 <= clipBound.x + clipBound.width && clipBound.y <= y && y <= clipBound.y + clipBound.height) {
                        g2.drawLine(x1, y, x2, y);
                    }
                    return null;
                }

                @Override
                public Void visit(MoreInferencesRow row) {
                    return null;
                }
            });
        }
    }

    NavButton getNavButton(int index) {
        ProofFrameListRow row = this.getProofListModel().getElementAt(index);
        if (row == null) {
            return null;
        }
        if (!row.isExpandable()) {
            return null;
        }
        int x = this.getNavX(row);
        int y = this.getNavY(row);
        if (row.isExpanded()) {
            this.navButton_.setIcon(TREE_EXPANDED, x, y);
        } else {
            this.navButton_.setIcon(TREE_COLLAPSED, x, y);
        }
        this.navButton_.setActionListener(e -> {
            switch (e.getActionCommand()) {
                case "Navigation Click": {
                    this.toggleExpandState(row);
                    break;
                }
                case "Navigation Button Click": {
                    this.toggleExpandRecursive(row);
                    break;
                }
                case "Navigation Button Long Press": {
                    this.toggleExpandRecursive(row);
                }
            }
        });
        return this.navButton_;
    }

    NavButton getNavButton(Point location) {
        int index = this.locationToIndex(location);
        NavButton button = this.getNavButton(index);
        if (button != null && button.getBounds().contains(location)) {
            return button;
        }
        return null;
    }

    protected List<MListButton> getButtons(Object item) {
        if (item instanceof MoreInferencesRow) {
            MoreInferencesRow row = (MoreInferencesRow)item;
            int index = row.getIndex();
            Rectangle rowBounds = this.getCellBound(index);
            MListButton button = this.moreInferencesButton_;
            button.setActionListener(e -> this.getProofListModel().loadMoreInferences(row.getParent()));
            int buttonDimension = this.getButtonDimension();
            button.setLocation(ProofFrameList.getRowIndent(row), rowBounds.y + (rowBounds.height / 2 - buttonDimension / 2));
            button.setSize(buttonDimension);
            return Collections.singletonList(button);
        }
        return super.getButtons(item);
    }

    class ProofFrameListMouseListener
    extends MouseAdapter
    implements ActionListener {
        private final Timer longPressTimer_ = new Timer(500, this);
        private boolean longPressActionTriggered_ = false;

        ProofFrameListMouseListener() {
            this.longPressTimer_.setRepeats(false);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            NavButton button = ProofFrameList.this.getNavButton(event.getPoint());
            if (button == null) {
                return;
            }
            this.longPressTimer_.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point point = ProofFrameList.this.getMousePosition();
            if (point == null) {
                return;
            }
            NavButton button = ProofFrameList.this.getNavButton(point);
            if (button == null) {
                return;
            }
            button.getActionListener().actionPerformed(new ActionEvent(this, 1001, ProofFrameList.NAV_LONG_PRESS));
            this.longPressActionTriggered_ = true;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            int index;
            if (this.longPressActionTriggered_) {
                this.longPressActionTriggered_ = false;
                return;
            }
            this.longPressTimer_.stop();
            Point location = event.getPoint();
            NavButton button = ProofFrameList.this.getNavButton(location);
            if (button != null) {
                button.getActionListener().actionPerformed(new ActionEvent(this, 1001, event.isAltDown() ? ProofFrameList.NAV_ALT_CLICK : ProofFrameList.NAV_CLICK));
            } else if (event.getClickCount() == 2 && ProofFrameList.this.getCellBound(index = ProofFrameList.this.locationToIndex(location)).contains(location)) {
                ProofFrameList.this.handleDoubleClick(ProofFrameList.this.getProofListModel().getElementAt(index));
            }
        }
    }

    class ProofFrameListUI
    extends OWLFrameList.OWLFrameListUI {
        private static final int MAX_LINE_HEIGHT_ = 24;
        private int[] cumulativeCellHeight;

        ProofFrameListUI() {
            super((OWLFrameList)ProofFrameList.this);
        }

        protected MouseInputListener createMouseInputListener() {
            final MouseInputListener oldListener = super.createMouseInputListener();
            return new MouseInputListener(){

                boolean shouldProcess(MouseEvent e) {
                    Point location = e.getPoint();
                    int index = ProofFrameList.this.locationToIndex(location);
                    return ProofFrameList.this.getCellBound(index).contains(location);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mousePressed(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseClicked(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseReleased(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseEntered(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseExited(e);
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseDragged(e);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.shouldProcess(e)) {
                        oldListener.mouseMoved(e);
                    }
                }
            };
        }

        protected void updateLayoutState() {
            block21: {
                this.cumulativeCellHeight = new int[this.list.getModel().getSize()];
                int fixedCellHeight = this.list.getFixedCellHeight();
                int fixedCellWidth = this.list.getFixedCellWidth();
                int n = this.cellWidth = fixedCellWidth != -1 ? fixedCellWidth : -1;
                if (fixedCellHeight != -1) {
                    this.cellHeight = fixedCellHeight;
                    this.cellHeights = null;
                } else {
                    this.cellHeight = -1;
                    this.cellHeights = new int[this.list.getModel().getSize()];
                }
                if (fixedCellWidth != -1 && fixedCellHeight != -1) break block21;
                ListModel dataModel = this.list.getModel();
                int dataModelSize = dataModel.getSize();
                ListCellRenderer renderer = this.list.getCellRenderer();
                if (renderer != null) {
                    Insets insets = this.list.getInsets();
                    int listWidth = this.list.getWidth() - (insets.left + insets.right);
                    int cumulativeHeight = 0;
                    for (int index = 0; index < dataModelSize; ++index) {
                        ProofFrameListRow row;
                        Object value = dataModel.getElementAt(index);
                        boolean useCachedHeight = false;
                        if (value instanceof ProofFrameListRow && (row = (ProofFrameListRow)value).getListMinWidth() <= listWidth && listWidth <= row.getListMaxWidth()) {
                            useCachedHeight = true;
                            this.cellHeights[index] = row.getCachedRowHeight();
                            if (fixedCellWidth == -1) {
                                this.cellWidth = Math.max(listWidth, this.cellWidth);
                            }
                        }
                        if (!useCachedHeight) {
                            Component c = renderer.getListCellRendererComponent(this.list, value, index, false, false);
                            this.rendererPane.add(c);
                            Dimension cellSize = c.getPreferredSize();
                            if (fixedCellWidth == -1) {
                                this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                            }
                            if (fixedCellHeight == -1) {
                                this.cellHeights[index] = cellSize.height;
                            }
                            if (value instanceof ProofFrameListRow) {
                                ProofFrameListRow row2 = (ProofFrameListRow)value;
                                if (cellSize.height != row2.getCachedRowHeight()) {
                                    row2.setCachedRowHeight(cellSize.height);
                                    row2.setListMinWidth(listWidth);
                                    if (cellSize.height <= 24) {
                                        row2.setListMaxWidth(Integer.MAX_VALUE);
                                    } else {
                                        row2.setListMaxWidth(listWidth);
                                    }
                                } else if (listWidth < row2.getListMinWidth()) {
                                    row2.setListMinWidth(listWidth);
                                } else if (listWidth > row2.getListMaxWidth()) {
                                    row2.setListMaxWidth(listWidth);
                                }
                            }
                        }
                        this.cumulativeCellHeight[index] = cumulativeHeight += this.cellHeights[index];
                    }
                } else {
                    if (this.cellWidth == -1) {
                        this.cellWidth = 0;
                    }
                    if (this.cellHeights == null) {
                        this.cellHeights = new int[dataModelSize];
                    }
                    for (int index = 0; index < dataModelSize; ++index) {
                        this.cellHeights[index] = 0;
                    }
                }
            }
        }

        public Rectangle getCellBounds(JList list, int index1, int index2) {
            this.maybeUpdateLayoutState();
            int minIndex = Math.min(index1, index2);
            int maxIndex = Math.max(index1, index2);
            if (minIndex >= list.getModel().getSize()) {
                return null;
            }
            Rectangle minBounds = this.getCellBounds(list, minIndex);
            if (minBounds == null) {
                return null;
            }
            if (minIndex == maxIndex) {
                return minBounds;
            }
            Rectangle maxBounds = this.getCellBounds(list, maxIndex);
            if (maxBounds != null) {
                if (minBounds.x != maxBounds.x) {
                    minBounds.y = 0;
                    minBounds.height = list.getHeight();
                }
                minBounds.add(maxBounds);
            }
            return minBounds;
        }

        private Rectangle getCellBounds(JList list, int index) {
            if (index < 0) {
                return new Rectangle();
            }
            this.maybeUpdateLayoutState();
            if (index >= this.cumulativeCellHeight.length) {
                return null;
            }
            Insets insets = list.getInsets();
            int x = insets.left;
            int y = index >= this.cellHeights.length ? 0 : this.cumulativeCellHeight[index] - this.cellHeights[index];
            int w = list.getWidth() - (insets.left + insets.right);
            int h = this.cellHeights[index];
            return new Rectangle(x, y, w, h);
        }
    }

    class ProofFrameListModel
    extends AbstractListModel<ProofFrameListRow>
    implements OWLFrameListener {
        private final ProofFrame frame_;
        private List<ProofFrameListRow> sections_;
        private int selectedIndex_ = -1;
        private final Deque<ProofFrameListRow> previousSelectionPath_ = new ArrayDeque<ProofFrameListRow>();

        ProofFrameListModel(ProofFrame frame) {
            this.frame_ = frame;
            this.frame_.addFrameListener(this);
        }

        private List<ProofFrameListRow> getSections() {
            this.initialize();
            return this.sections_;
        }

        private boolean invalidate() {
            if (this.sections_ == null) {
                return false;
            }
            for (ProofFrameListRow next = this.getElementAt(this.selectedIndex_); next != null; next = next.getParent()) {
                this.previousSelectionPath_.addFirst(next);
            }
            this.setHighlightsFor(-1);
            this.sections_ = null;
            return true;
        }

        private boolean initialize() {
            ProofFrameListRow next;
            if (this.sections_ != null) {
                return false;
            }
            this.sections_ = new ArrayList<ProofFrameListRow>();
            ArrayDeque<ProofFrameListRow> todo = new ArrayDeque<ProofFrameListRow>();
            todo.add(this.frame_.getRootSection().getRow());
            int newSelectedIndex = -1;
            ProofFrameListRow nextSelectedCandidate = this.previousSelectionPath_.poll();
            while ((next = (ProofFrameListRow)todo.poll()) != null) {
                ConclusionSection row;
                int index = this.sections_.size();
                next.setIndex(index);
                if (this.getIndex(next.getParent()) == newSelectedIndex && (next.matches(nextSelectedCandidate) || nextSelectedCandidate instanceof MoreInferencesRow && nextSelectedCandidate.getIndex() == index)) {
                    newSelectedIndex = index;
                    nextSelectedCandidate = this.previousSelectionPath_.poll();
                }
                this.sections_.add(next);
                if (!next.isExpanded()) continue;
                List<? extends ProofFrameListRow> children = next.getChildren();
                if (next instanceof ConclusionSection && (row = (ConclusionSection)next).hasMoreChildren()) {
                    todo.push(new MoreInferencesRow(row));
                }
                for (int i = children.size() - 1; i >= 0; --i) {
                    todo.push(children.get(i));
                }
            }
            this.previousSelectionPath_.clear();
            ProofFrameList.this.setSelectedIndex(newSelectedIndex);
            this.setHighlightsFor(newSelectedIndex);
            return true;
        }

        private int getIndex(ProofFrameListRow row) {
            if (row == null) {
                return -1;
            }
            return row.getIndex();
        }

        private void setHighlightsFor(int newSelectedIndex) {
            int oldSelectedIndex = this.selectedIndex_;
            if (oldSelectedIndex == newSelectedIndex) {
                return;
            }
            this.selectedIndex_ = newSelectedIndex;
            this.handleHighlightChange(oldSelectedIndex);
            this.handleHighlightChange(this.selectedIndex_);
        }

        private void handleHighlightChange(int index) {
            if (index < 0 || index >= this.getSize()) {
                return;
            }
            ProofFrameListRow item = this.getElementAt(index);
            item.accept(new ProofFrameListRow.Visitor<Void>(){

                @Override
                public Void visit(ConclusionSection row) {
                    return null;
                }

                @Override
                public Void visit(InferenceRow row) {
                    ProofFrameListModel.this.toggleHighlightChildren(row);
                    ConclusionSection conclusion = row.getParent();
                    if (conclusion != null) {
                        ProofFrameListModel.this.toggleHighlight(conclusion);
                    }
                    return null;
                }

                @Override
                public Void visit(MoreInferencesRow row) {
                    return null;
                }
            });
        }

        private void toggleHighlight(ProofFrameListRow row) {
            row.toggleHighlight();
            int changedIndex = row.getIndex();
            Rectangle bounds = ProofFrameList.this.getCellBounds(changedIndex, changedIndex);
            if (bounds != null) {
                int oldX = bounds.x;
                bounds.x = ProofFrameList.getRowIndent(row);
                bounds.width = bounds.width + oldX - bounds.x;
                ProofFrameList.this.repaint(bounds);
            }
        }

        private void toggleHighlightChildren(ProofFrameListRow row) {
            for (ProofFrameListRow proofFrameListRow : row.getChildren()) {
                this.toggleHighlight(proofFrameListRow);
            }
        }

        private void toggleExpandState(ProofFrameListRow row) {
            if (!row.isExpandable()) {
                return;
            }
            int intervalBegin = row.getIndex() + 1;
            if (row.isExpanded()) {
                int intervalEnd = this.getLowestExpandedDescendant(row).getIndex();
                row.toggleExpandState();
                this.invalidate();
                this.fireIntervalRemoved(this, intervalBegin, intervalEnd);
            } else {
                row.toggleExpandState();
                this.invalidate();
                int intervalEnd = this.getLowestExpandedDescendant(row).getIndex();
                this.fireIntervalAdded(this, intervalBegin, intervalEnd);
            }
        }

        private void toggleExpandRecursive(ProofFrameListRow row) {
            if (!row.isExpandable()) {
                return;
            }
            int intervalBegin = row.getIndex() + 1;
            if (row.isExpanded()) {
                int intervalEnd = this.getLowestExpandedDescendant(row).getIndex();
                row.collapseRecursively(Integer.MAX_VALUE);
                this.invalidate();
                this.fireIntervalRemoved(this, intervalBegin, intervalEnd);
            } else {
                row.expandRecursively(ProofFrameList.this.recursiveExpansionLimit_);
                this.invalidate();
                int intervalEnd = this.getLowestExpandedDescendant(row).getIndex();
                this.fireIntervalAdded(this, intervalBegin, intervalEnd);
            }
        }

        private void loadMoreInferences(ConclusionSection row) {
            int intervalBegin = this.getLowestExpandedDescendant(row).getIndex();
            row.loadMoreChildren();
            this.invalidate();
            int intervalEnd = this.getLowestExpandedDescendant(row).getIndex();
            this.fireIntervalAdded(this, intervalBegin, intervalEnd);
        }

        private ProofFrameListRow getLowestExpandedDescendant(ProofFrameListRow parent) {
            ProofFrameListRow lowest = parent;
            while (lowest.isExpanded()) {
                List<? extends ProofFrameListRow> children = lowest.getChildren();
                int childCount = children.size();
                if (childCount == 0) {
                    return lowest;
                }
                lowest = children.get(childCount - 1);
            }
            return lowest;
        }

        @Override
        public int getSize() {
            return this.getSections().size();
        }

        @Override
        public ProofFrameListRow getElementAt(int index) {
            if (index < 0 || index >= this.getSections().size()) {
                return null;
            }
            return this.getSections().get(index);
        }

        public void frameContentChanged() throws Exception {
            if (!this.invalidate()) {
                return;
            }
            this.initialize();
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }
}

