/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;
import org.liveontologies.protege.explanation.proof.list.ConclusionSection;
import org.liveontologies.protege.explanation.proof.list.InferenceRow;
import org.liveontologies.protege.explanation.proof.list.MoreInferencesRow;
import org.liveontologies.protege.explanation.proof.list.ProofFrameList;
import org.liveontologies.protege.explanation.proof.list.ProofFrameListRow;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;

public class ProofFrameListRenderer
implements ListCellRenderer<ProofFrameListRow> {
    private static final Color FRAME_SECTION_HEADER_FOREGROUND = Color.GRAY;
    private static final Color FRAME_SECTION_HEADER_HIGH_CONTRAST_FOREGROUND = new Color(40, 40, 40);
    private OWLCellRenderer owlCellRenderer;
    private ListCellRenderer<Object> separatorRenderer;

    public ProofFrameListRenderer(OWLEditorKit owlEditorKit) {
        this.owlCellRenderer = new OWLCellRenderer(owlEditorKit);
        this.separatorRenderer = new DefaultListCellRenderer();
    }

    @Override
    public Component getListCellRendererComponent(final JList<? extends ProofFrameListRow> list, ProofFrameListRow value, final int index, final boolean isSelected, final boolean cellHasFocus) {
        return value.accept(new ProofFrameListRow.Visitor<Component>(){

            @Override
            public Component visit(ConclusionSection row) {
                Object valueToRender = ProofFrameListRenderer.this.getValueToRender(list, row, index, isSelected, cellHasFocus);
                ProofFrameListRenderer.this.owlCellRenderer.setCommentedOut(false);
                ProofFrameListRenderer.this.owlCellRenderer.setOntology(row.getOntology());
                ProofFrameListRenderer.this.owlCellRenderer.setInferred(row.isInferred());
                ProofFrameListRenderer.this.owlCellRenderer.setHighlightKeywords(true);
                ProofFrameListRenderer.this.owlCellRenderer.setHighlightUnsatisfiableClasses(true);
                ProofFrameListRenderer.this.owlCellRenderer.setHighlightUnsatisfiableProperties(true);
                ProofFrameListRenderer.this.owlCellRenderer.setIconObject((OWLObject)row.getAxiom());
                return (JPanel)ProofFrameListRenderer.this.owlCellRenderer.getListCellRendererComponent(list, valueToRender, index, isSelected, cellHasFocus);
            }

            @Override
            public Component visit(InferenceRow row) {
                JLabel label = (JLabel)ProofFrameListRenderer.this.separatorRenderer.getListCellRendererComponent(list, row.getName(), index, isSelected, cellHasFocus);
                Font font = label.getFont();
                font = font.deriveFont(font.getStyle(), (float)font.getSize() * 0.9f);
                label.setFont(font);
                label.setForeground(isSelected ? list.getSelectionForeground() : ProofFrameListRenderer.this.getSectionHeaderForeground());
                label.setVerticalAlignment(1);
                int padding = ProofFrameList.getRowIndent(row);
                MatteBorder externalBorder = BorderFactory.createMatteBorder(0, padding, 0, 0, list.getBackground());
                label.setBorder(externalBorder);
                return label;
            }

            @Override
            public Component visit(MoreInferencesRow row) {
                JLabel label = (JLabel)ProofFrameListRenderer.this.separatorRenderer.getListCellRendererComponent(list, " ", index, isSelected, cellHasFocus);
                int padding = ProofFrameList.getRowIndent(row);
                MatteBorder externalBorder = BorderFactory.createMatteBorder(0, padding, 0, 0, list.getBackground());
                label.setBorder(externalBorder);
                return label;
            }
        });
    }

    private Color getSectionHeaderForeground() {
        if (UIUtil.isHighContrastOn()) {
            return FRAME_SECTION_HEADER_HIGH_CONTRAST_FOREGROUND;
        }
        return FRAME_SECTION_HEADER_FOREGROUND;
    }

    public void setWrap(boolean b) {
        this.owlCellRenderer.setWrap(b);
    }

    protected Object getValueToRender(JList<?> list, ConclusionSection value, int index, boolean isSelected, boolean cellHasFocus) {
        return value.getRendering();
    }
}

