/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.liveontologies.protege.explanation.proof.OWLRenderer;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Inferences;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofStep;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class ProofRoot
implements ProofStep<OWLAxiom>,
ProofNode<OWLAxiom> {
    static final String SOME_PROOF = "Proof tree for entailment";
    static final String NO_PROOF = "No proof for the entailment found.";
    private final OWLAxiom member_;
    private final List<? extends ProofNode<OWLAxiom>> premises_;
    private final OWLRenderer renderer_;

    ProofRoot(OWLAxiom member, List<? extends ProofNode<OWLAxiom>> premises, OWLRenderer renderer) {
        this.member_ = member;
        this.premises_ = premises;
        this.renderer_ = renderer;
    }

    public String getName() {
        return this.premises_.isEmpty() ? NO_PROOF : SOME_PROOF;
    }

    public ProofNode<OWLAxiom> getConclusion() {
        return this;
    }

    public List<? extends ProofNode<OWLAxiom>> getPremises() {
        return this.premises_;
    }

    public OWLAxiom getMember() {
        return this.member_;
    }

    public Collection<? extends ProofStep<OWLAxiom>> getInferences() {
        return Collections.singleton(this);
    }

    public String toString() {
        return "Proof for " + this.renderer_.render((OWLObject)this.getMember());
    }

    public Inference<OWLAxiom> getInference() {
        return Inferences.create((String)this.getName(), (Object)this.member_, (List)new AbstractList<OWLAxiom>(){

            @Override
            public OWLAxiom get(int index) {
                return (OWLAxiom)((ProofNode)ProofRoot.this.premises_.get(index)).getMember();
            }

            @Override
            public int size() {
                return ProofRoot.this.premises_.size();
            }
        });
    }
}

