/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.preferences;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class ProofBasedExplPrefs {
    private static final String PREFS_KEY_ = "PROOF_BASED_EXPLANATION_PREFS";
    private static final String RECURSIVE_EXPANSION_LIMIT_KEY_ = "RECURSIVE_EXPANSION_LIMIT";
    private static final String DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT_KEY = "DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT";
    private static final String REMOVE_UNNECESSARY_INFERENCES_KEY = "REMOVE_UNNECESSARY_INFERENCES";
    public static final String RECURSIVE_EXPANSION_LIMIT_DESCRIPTION = "The maximal number of inferences expanded upon long press or alt + click";
    public static final String DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT_DESCRIPTION = "The maximal number of inferences displayed at once for each conclusion";
    public static final String REMOVE_UNNECESSARY_INFERENCES_DESCRIPTION = "If checked, remove inferences unless it prevents the entailment to be derived from any subset of axioms in the ontology";
    private static final int DEFAULT_RECURSIVE_EXPANSION_LIMIT_ = 300;
    private static final int DEFAULT_DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT_ = 5;
    private static final boolean DEFAULT_REMOVE_UNNECESSARY_INFERENCES_ = true;
    public int recursiveExpansionLimit = 300;
    public int displayedInferencesPerConclusionLimit = 5;
    public boolean removeUnnecessaryInferences = true;

    private ProofBasedExplPrefs() {
    }

    private static Preferences getPrefs() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        return prefMan.getPreferencesForSet(PREFS_KEY_, ProofBasedExplPrefs.class);
    }

    public static ProofBasedExplPrefs create() {
        return new ProofBasedExplPrefs();
    }

    public ProofBasedExplPrefs load() {
        Preferences prefs = ProofBasedExplPrefs.getPrefs();
        this.recursiveExpansionLimit = prefs.getInt(RECURSIVE_EXPANSION_LIMIT_KEY_, 300);
        this.displayedInferencesPerConclusionLimit = prefs.getInt(DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT_KEY, 5);
        this.removeUnnecessaryInferences = prefs.getBoolean(REMOVE_UNNECESSARY_INFERENCES_KEY, true);
        return this;
    }

    public ProofBasedExplPrefs save() {
        Preferences prefs = ProofBasedExplPrefs.getPrefs();
        prefs.putInt(RECURSIVE_EXPANSION_LIMIT_KEY_, this.recursiveExpansionLimit);
        prefs.putInt(DISPLAYED_INFERENCES_PER_CONCLUSION_LIMIT_KEY, this.displayedInferencesPerConclusionLimit);
        prefs.putBoolean(REMOVE_UNNECESSARY_INFERENCES_KEY, this.removeUnnecessaryInferences);
        return this;
    }

    public ProofBasedExplPrefs reset() {
        this.recursiveExpansionLimit = 300;
        this.displayedInferencesPerConclusionLimit = 5;
        this.removeUnnecessaryInferences = true;
        return this;
    }
}

