/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.liveontologies.protege.explanation.proof.ProofServiceManager;
import org.liveontologies.protege.explanation.proof.preferences.ProofBasedExplPrefs;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class ProofBasedExplanationPreferencesGeneralPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 8585913940466665136L;
    private SpinnerNumberModel recursiveExpansionLimitModel_;
    private SpinnerNumberModel displayedInferencesPerConclusionLimitModel_;
    private JCheckBox removeUnnecessaryInferences_;

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        this.addInstalledProofServicesComponent(panel);
        this.addRecursiveExpansionLimitSettings(panel);
        this.addDisplayedInferencesPerConclusionLimitSettings(panel);
        this.addRemoveUnnecessaryInferencesSettings(panel);
        panel.addGroup("");
        panel.addGroupComponent(this.buildResetComponent());
        this.loadFrom(ProofBasedExplPrefs.create().load());
    }

    public void dispose() throws Exception {
    }

    public void applyChanges() {
        ProofBasedExplPrefs prefs = ProofBasedExplPrefs.create();
        this.saveTo(prefs);
        prefs.save();
    }

    private void loadFrom(ProofBasedExplPrefs prefs) {
        this.recursiveExpansionLimitModel_.setValue(prefs.recursiveExpansionLimit);
        this.displayedInferencesPerConclusionLimitModel_.setValue(prefs.displayedInferencesPerConclusionLimit);
        this.removeUnnecessaryInferences_.setSelected(prefs.removeUnnecessaryInferences);
    }

    private void saveTo(ProofBasedExplPrefs prefs) {
        prefs.recursiveExpansionLimit = this.recursiveExpansionLimitModel_.getNumber().intValue();
        prefs.displayedInferencesPerConclusionLimit = this.displayedInferencesPerConclusionLimitModel_.getNumber().intValue();
        prefs.removeUnnecessaryInferences = this.removeUnnecessaryInferences_.isSelected();
    }

    private void addInstalledProofServicesComponent(PreferencesLayoutPanel panel) throws Exception {
        panel.addGroup("Installed proof services");
        DefaultListModel<ProofService> proofServicesModel = new DefaultListModel<ProofService>();
        Collection<ProofService> proofServices = ProofServiceManager.get(this.getOWLEditorKit()).getProofServices();
        for (ProofService proofService : proofServices) {
            proofServicesModel.addElement(proofService);
        }
        JList proofServicesList = new JList(proofServicesModel);
        proofServicesList.setToolTipText("Plugins that provide proofs that are displayed for explanation of entailments");
        JScrollPane pluginInfoScrollPane = new JScrollPane(proofServicesList);
        pluginInfoScrollPane.setPreferredSize(new Dimension(300, 100));
        panel.addGroupComponent((JComponent)pluginInfoScrollPane);
    }

    private void addRecursiveExpansionLimitSettings(PreferencesLayoutPanel panel) {
        panel.addGroup("Recursive expansion limit");
        this.recursiveExpansionLimitModel_ = new SpinnerNumberModel(1, 1, 9999, 1);
        JSpinner spinner = new JSpinner(this.recursiveExpansionLimitModel_);
        spinner.setMaximumSize(spinner.getPreferredSize());
        panel.addGroupComponent((JComponent)spinner);
        String tooltip = "The maximal number of inferences expanded upon long press or alt + click";
        spinner.setToolTipText(tooltip);
    }

    private void addDisplayedInferencesPerConclusionLimitSettings(PreferencesLayoutPanel panel) {
        panel.addGroup("Displayed inferences per conclusion");
        this.displayedInferencesPerConclusionLimitModel_ = new SpinnerNumberModel(1, 1, 9999, 1);
        JSpinner spinner = new JSpinner(this.displayedInferencesPerConclusionLimitModel_);
        this.displayedInferencesPerConclusionLimitModel_.setMaximum(Integer.valueOf(999));
        spinner.setMaximumSize(spinner.getPreferredSize());
        panel.addGroupComponent((JComponent)spinner);
        String tooltip = "The maximal number of inferences displayed at once for each conclusion";
        spinner.setToolTipText(tooltip);
    }

    private void addRemoveUnnecessaryInferencesSettings(PreferencesLayoutPanel panel) {
        this.removeUnnecessaryInferences_ = new JCheckBox("Remove unnecessary inferences");
        panel.addGroupComponent((JComponent)this.removeUnnecessaryInferences_);
        this.removeUnnecessaryInferences_.setToolTipText("If checked, remove inferences unless it prevents the entailment to be derived from any subset of axioms in the ontology");
    }

    private JComponent buildResetComponent() {
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> this.reset());
        resetButton.setToolTipText("Resets all settings to default values");
        return resetButton;
    }

    private void reset() {
        this.loadFrom(ProofBasedExplPrefs.create());
    }
}

