/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.liquibasefacade;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.llorllale.liquibasefacade.NullVersion;
import org.llorllale.liquibasefacade.UndefinedVersion;
import org.llorllale.liquibasefacade.Version;

public class LinearProgressionFacade {
    private final Connection connection;
    private final List<Version> versions;
    private final Function<Version, String> changesetFileLocator;
    private final Function<Version, ResourceAccessor> resourceAccessorGenerator;
    private static final String CHANGELOG_TABLE = "databasechangelog".toUpperCase();
    private static final String SQL_GET_APPLIED_VERSIONS = String.format("select tag from %s where tag is not null order by orderexecuted desc", CHANGELOG_TABLE);

    public LinearProgressionFacade(Connection connection, List<Version> versions, Function<Version, String> changesetFileLocator, Function<Version, ResourceAccessor> resourceAccessorGenerator) throws LiquibaseException {
        this.connection = Objects.requireNonNull(connection, "null connection.");
        this.versions = Optional.of(new ArrayList(Objects.requireNonNull(versions, "null version list."))).filter(v -> v.size() > 0).orElseThrow(() -> new IllegalArgumentException("empty version list."));
        this.changesetFileLocator = Objects.requireNonNull(changesetFileLocator, "null changesetFileLocator function.");
        this.resourceAccessorGenerator = Objects.requireNonNull(resourceAccessorGenerator, "null resourceAccessorGenerator function.");
        this.errorOnInconsistentDatabaseRevisions();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<Version> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public boolean isUpgrade(Version version) throws LiquibaseException {
        this.errorIfInvalidInput(version);
        this.errorOnInconsistentDatabaseRevisions();
        return this.getCurrentVersion().isLessThan(version);
    }

    public boolean isDowngrade(Version version) throws LiquibaseException {
        this.errorIfInvalidInput(version);
        this.errorOnInconsistentDatabaseRevisions();
        return this.getCurrentVersion().isGreaterThan(version);
    }

    public int apply(int major, int minor, int release) throws LiquibaseException {
        return this.apply(Version.of(major, minor, release));
    }

    public int applyAll() throws LiquibaseException {
        return this.apply((Version)this.versions.stream().max((v1, v2) -> v1.compareTo((Version)v2)).get());
    }

    public int rollbackAll() throws LiquibaseException {
        return this.downgradeDatabase(new NullVersion());
    }

    public int apply(Version targetVersion) throws LiquibaseException {
        this.errorIfInvalidInput(targetVersion);
        int changes = 0;
        if (this.isDowngrade(targetVersion)) {
            changes = this.downgradeDatabase(targetVersion);
        } else if (this.isUpgrade(targetVersion)) {
            changes = this.upgradeDatabase(targetVersion);
        }
        return changes;
    }

    public Version getCurrentVersion() throws LiquibaseException {
        this.errorOnInconsistentDatabaseRevisions();
        return this._getCurrentVersion();
    }

    public boolean isVersioned() throws LiquibaseException {
        ResultSet r = null;
        try {
            DatabaseMetaData md = this.connection.getMetaData();
            r = md.getTables(null, null, CHANGELOG_TABLE, new String[]{"TABLE"});
            boolean bl = r.next();
            return bl;
        }
        catch (SQLException e) {
            throw new LiquibaseException("Unable to determine if database is versioned.", (Throwable)e);
        }
        finally {
            try {
                r.close();
            }
            catch (Exception e) {}
        }
    }

    private void errorIfInvalidInput(Version version) {
        if (UndefinedVersion.isUndefinedVersion(version)) {
            throw new IllegalArgumentException("Illegal argument for 'version' - version is 'UndefinedVersion'.");
        }
        if (NullVersion.isNullVersion(version)) {
            throw new IllegalArgumentException("Illegal argument for 'version' - version is 'NullVersion'.");
        }
        if (!this.versions.contains(version)) {
            throw new IllegalArgumentException(String.format("Illegal argument for 'version' - version not found in list of versions. Version: %s List of versions: %s", version, this.versions));
        }
    }

    private Version _getCurrentVersion() throws LiquibaseException {
        Version version;
        block28: {
            version = null;
            if (this.isVersioned()) {
                try (PreparedStatement stmt = this.connection.prepareStatement(SQL_GET_APPLIED_VERSIONS);
                     ResultSet result = stmt.executeQuery();){
                    version = result.next() ? Version.valueOf(result.getString(1)) : new NullVersion();
                    break block28;
                }
                catch (Exception e) {
                    throw new LiquibaseException("Unable to read the current version from the database.", (Throwable)e);
                }
            }
            version = new UndefinedVersion();
        }
        if (!(NullVersion.isNullVersion(version) || UndefinedVersion.isUndefinedVersion(version) || this.versions.contains(version))) {
            throw new IllegalStateException(String.format("Version %s not found in the database is NOT found in the supplied list of versions. Make sure the calling code and the database state are mutually consistent.", version.string()));
        }
        return version;
    }

    private void errorOnInconsistentDatabaseRevisions() throws LiquibaseException {
        Version currentVersion = this._getCurrentVersion();
        if (!NullVersion.isNullVersion(currentVersion) && !UndefinedVersion.isUndefinedVersion(currentVersion)) {
            ArrayList<Version> copy = new ArrayList<Version>(this.versions);
            Collections.sort(copy);
            Stack<Version> databaseVersions = new Stack<Version>();
            try (PreparedStatement stmt = this.connection.prepareStatement(SQL_GET_APPLIED_VERSIONS);
                 ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    databaseVersions.push(Version.valueOf(result.getString(1)));
                }
            }
            catch (SQLException e) {
                throw new LiquibaseException("Error reading database schema metadata!", (Throwable)e);
            }
            Collections.sort(databaseVersions);
            if (databaseVersions.size() > copy.size()) {
                throw new IllegalStateException(String.format("The database' schema has been applied versions not found in the supplied list of versions. Make sure the calling code and the database state are mutually consistent.", new Object[0]));
            }
            for (int i = 0; i < databaseVersions.size(); ++i) {
                if (((Version)databaseVersions.get(i)).equals(copy.get(i))) continue;
                throw new IllegalStateException(String.format("The database' schema has been applied versions not found in the supplied list of versions. Make sure the calling code and the database state are mutually consistent.", new Object[0]));
            }
        }
    }

    private int upgradeDatabase(Version targetVersion) throws LiquibaseException {
        this.errorOnInconsistentDatabaseRevisions();
        Version currentVersion = this.getCurrentVersion();
        int changesApplied = 0;
        if (targetVersion.isEqualOrLessThan(currentVersion)) {
            throw new LiquibaseException(String.format("Target version is equal or less than the current version. Target: %s Current: %s", targetVersion, currentVersion));
        }
        ArrayList<Version> forwardList = new ArrayList<Version>(this.versions);
        Collections.sort(forwardList);
        try {
            for (Version version : forwardList) {
                if (!version.isGreaterThan(currentVersion) || !version.isEqualOrLessThan(targetVersion)) continue;
                Liquibase liquibase = this.getLiquibaseInstance(version, this.changesetFileLocator, this.resourceAccessorGenerator, this.connection);
                int changeSetCount = this.getChangesetCount(liquibase);
                for (int i = 0; i < changeSetCount; ++i) {
                    liquibase.update(1, null);
                    ++changesApplied;
                }
                liquibase.tag(version.string());
            }
        }
        catch (Exception e) {
            throw new LiquibaseException("Error while attempting to upgrade the schema to version " + targetVersion, (Throwable)e);
        }
        return changesApplied;
    }

    private int downgradeDatabase(Version targetVersion) throws LiquibaseException {
        this.errorOnInconsistentDatabaseRevisions();
        Version currentVersion = this.getCurrentVersion();
        int changesApplied = 0;
        if (targetVersion.isEqualOrGreaterThan(currentVersion)) {
            throw new LiquibaseException(String.format("Target version is equal or greater than the current version. Target: %s Current: %s", targetVersion, currentVersion));
        }
        ArrayList<Version> reversedList = new ArrayList<Version>(this.versions);
        Collections.sort(reversedList);
        Collections.reverse(reversedList);
        try {
            for (Version version : reversedList) {
                if (!version.isEqualOrLessThan(currentVersion) || !version.isGreaterThan(targetVersion)) continue;
                Liquibase liquibase = this.getLiquibaseInstance(version, this.changesetFileLocator, this.resourceAccessorGenerator, this.connection);
                int changeSetCount = this.getChangesetCount(liquibase);
                for (int i = 0; i < changeSetCount; ++i) {
                    liquibase.rollback(1, null);
                    ++changesApplied;
                }
            }
        }
        catch (Exception e) {
            throw new LiquibaseException("Error while attempting to downgrade the schema to version " + targetVersion, (Throwable)e);
        }
        return changesApplied;
    }

    private Database getLiquibaseDatabase(Connection connection) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (database == null) {
            throw new LiquibaseException("Null liquibase database.");
        }
        database.setAutoCommit(true);
        return database;
    }

    private int getChangesetCount(Liquibase liquibase) throws LiquibaseException {
        return liquibase.getDatabaseChangeLog().getChangeSets().size();
    }

    private Liquibase getLiquibaseInstance(Version version, Function<Version, String> locator, Function<Version, ResourceAccessor> generator, Connection connection) throws LiquibaseException {
        return new Liquibase(locator.apply(version), generator.apply(version), this.getLiquibaseDatabase(connection));
    }
}

