/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.liquibasefacade;

import org.llorllale.liquibasefacade.NullVersion;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int release;

    protected Version(int major, int minor, int release) {
        this.major = major;
        this.minor = minor;
        this.release = release;
    }

    public static Version of(int major, int minor, int release) {
        if (major == 0 && minor == 0 && release == 0) {
            throw new IllegalArgumentException(String.format("Version '0.0.0' reserved for '%s'.", new NullVersion()));
        }
        if (major < 0) {
            throw new IllegalArgumentException("Negative major version value: " + major);
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Negative minor version value: " + minor);
        }
        if (release < 0) {
            throw new IllegalArgumentException("Negative release version value: " + release);
        }
        return new Version(major, minor, release);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.major;
        hash = 79 * hash + this.minor;
        hash = 79 * hash + this.release;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.release == other.release;
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.release > o.release) {
            return 1;
        }
        if (this.release < o.release) {
            return -1;
        }
        return 0;
    }

    public boolean isGreaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isEqualOrGreaterThan(Version other) {
        return this.equals(other) || this.compareTo(other) > 0;
    }

    public boolean isLessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isEqualOrLessThan(Version other) {
        return this.equals(other) || this.compareTo(other) < 0;
    }

    static Version valueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null argument.");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Empty string.");
        }
        String[] parts = s.split("\\.", 3);
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Wrong format in string %s. The format is X.Y.Z", s));
        }
        try {
            int major = Integer.valueOf(parts[0]);
            int minor = Integer.valueOf(parts[1]);
            int release = Integer.valueOf(parts[2]);
            return new Version(major, minor, release);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("Wrong format in string %s. The format is X.Y.Z where X, Y, and Z must the intergers.", s));
        }
    }

    public String string() {
        return this.major + "." + this.minor + "." + this.release;
    }

    public String toString() {
        return "Version{major=" + this.major + ", minor=" + this.minor + ", release=" + this.release + '}';
    }
}

