/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.mvn.plgn.loggit;

import com.jcabi.xml.XML;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.Input;
import org.cactoos.Output;
import org.cactoos.Scalar;
import org.cactoos.io.InputOf;
import org.cactoos.io.LengthOf;
import org.cactoos.io.OutputTo;
import org.cactoos.io.TeeInput;
import org.cactoos.scalar.IoCheckedScalar;
import org.llorllale.mvn.plgn.loggit.DefaultGit;
import org.llorllale.mvn.plgn.loggit.xsl.Custom;
import org.llorllale.mvn.plgn.loggit.xsl.Identity;
import org.llorllale.mvn.plgn.loggit.xsl.Markdown;

@Mojo(name="changelog")
public final class Changelog
extends AbstractMojo {
    @Parameter(name="repo", defaultValue="${basedir}")
    private File repo;
    @Parameter(name="outputFile", defaultValue="gitlog.xml")
    private File xml;
    @Parameter(name="format", defaultValue="default")
    private String format;
    @Parameter(name="customFormatFile")
    private File customFormat;
    @Parameter(name="ref", defaultValue="master")
    private String ref;

    public Changelog() {
    }

    public Changelog(File repo, File output) {
        this(repo, output, "default");
    }

    public Changelog(File repo, File output, String format) {
        this(repo, output, format, null);
    }

    public Changelog(File repo, File output, String format, File customFormat) {
        this(repo, output, format, customFormat, "master");
    }

    public Changelog(File repo, File output, String format, File customFormat, String ref) {
        this.repo = repo;
        this.xml = output;
        this.format = format;
        this.customFormat = customFormat;
        this.ref = ref;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new IoCheckedScalar((Scalar)new LengthOf((Input)new TeeInput((Input)new InputOf((CharSequence)this.transform(new DefaultGit(this.repo.toPath().resolve(".git"), this.ref).log().asXml())), (Output)new OutputTo(this.xml)))).value();
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Cannot save XML from repo %s to file %s", this.repo, this.xml), (Throwable)e);
        }
    }

    private String transform(XML original) throws IOException {
        String output = "markdown".equals(this.format) ? new Markdown().applyTo(original) : ("custom".equals(this.format) ? new Custom((Input)new InputOf(this.customFormat)).applyTo(original) : new Identity().applyTo(original));
        return output;
    }
}

