/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.mvn.plgn.loggit;

import com.jcabi.xml.XML;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.Input;
import org.cactoos.Output;
import org.cactoos.Scalar;
import org.cactoos.io.InputOf;
import org.cactoos.io.LengthOf;
import org.cactoos.io.OutputTo;
import org.cactoos.io.TeeInput;
import org.cactoos.scalar.IoCheckedScalar;
import org.llorllale.mvn.plgn.loggit.DefaultGit;
import org.llorllale.mvn.plgn.loggit.xsl.post.Custom;
import org.llorllale.mvn.plgn.loggit.xsl.post.Identity;
import org.llorllale.mvn.plgn.loggit.xsl.post.Markdown;
import org.llorllale.mvn.plgn.loggit.xsl.pre.EndTag;
import org.llorllale.mvn.plgn.loggit.xsl.pre.Limit;
import org.llorllale.mvn.plgn.loggit.xsl.pre.Pattern;
import org.llorllale.mvn.plgn.loggit.xsl.pre.StartTag;

@Mojo(name="changelog")
public final class Changelog
extends AbstractMojo {
    @Parameter(name="repo", defaultValue="${basedir}")
    private File repo;
    @Parameter(name="outputFile", defaultValue="${project.build.directory}/gitlog.xml")
    private File outputFile;
    @Parameter(name="format", defaultValue="default")
    private String format;
    @Parameter(name="customFormatFile")
    private File customFormatFile;
    @Parameter(name="branch", defaultValue="master")
    private String branch;
    @Parameter(name="maxEntries", defaultValue="2147483647")
    private int maxEntries;
    @Parameter(name="startTag", defaultValue="")
    private String startTag;
    @Parameter(name="endTag", defaultValue="")
    private String endTag;
    @Parameter(name="includeRegex", defaultValue=".*")
    private String includeRegex;

    public Changelog() {
    }

    public Changelog(File repo, File output) {
        this(repo, output, "default");
    }

    public Changelog(File repo, File output, String format) {
        this(repo, output, format, null);
    }

    public Changelog(File repo, File output, String format, File customFormat) {
        this(repo, output, format, customFormat, "master");
    }

    public Changelog(File repo, File output, String format, File customFormat, String branch) {
        this(repo, output, format, customFormat, branch, Integer.MAX_VALUE);
    }

    public Changelog(File repo, File output, String format, File customFormat, String branch, int maxEntries) {
        this(repo, output, format, customFormat, branch, maxEntries, "");
    }

    public Changelog(File repo, File output, String format, File customFormat, String branch, int maxEntries, String startTag) {
        this(repo, output, format, customFormat, branch, maxEntries, startTag, ".*");
    }

    public Changelog(File repo, File output, String format, File customFormat, String branch, int maxEntries, String startTag, String includeRegex) {
        this(repo, output, format, customFormat, branch, maxEntries, startTag, includeRegex, "");
    }

    public Changelog(File repo, File output, String format, File customFormat, String branch, int maxEntries, String startTag, String includeRegex, String endTag) {
        this.repo = repo;
        this.outputFile = output;
        this.format = format;
        this.customFormatFile = customFormat;
        this.branch = branch;
        this.maxEntries = maxEntries;
        this.startTag = startTag;
        this.includeRegex = includeRegex;
        this.endTag = endTag;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new IoCheckedScalar((Scalar)new LengthOf((Input)new TeeInput((Input)new InputOf((CharSequence)this.postprocess(this.preprocess(new DefaultGit(this.repo.toPath().resolve(".git"), this.branch).log().asXml()))), (Output)new OutputTo(this.outputFile)))).value();
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Cannot save XML from repo %s to file %s", this.repo, this.outputFile), (Throwable)e);
        }
    }

    private String postprocess(XML original) throws IOException {
        String output = "markdown".equals(this.format) ? new Markdown().applyTo(original) : ("custom".equals(this.format) ? new Custom((Input)new InputOf(this.customFormatFile)).applyTo(original) : new Identity().applyTo(original));
        return output;
    }

    private XML preprocess(XML xml) throws IOException {
        return new Pattern(this.includeRegex).transform(new EndTag(this.endTag).transform(new StartTag(this.startTag).transform(new Limit(this.maxEntries).transform(xml))));
    }
}

