/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.mvn.plgn.releasecat;

import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.Repo;
import com.jcabi.github.RtGithub;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.Scalar;
import org.cactoos.scalar.IoCheckedScalar;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public final class Upload
extends AbstractMojo {
    @Parameter(name="token", property="releasecat.token")
    private String token;
    @Parameter(name="user", property="releasecat.user")
    private String user;
    @Parameter(name="repo", property="releasecat.repo")
    private String repo;
    @Parameter(name="tag", property="releasecat.tag")
    private String tag;
    @Parameter(name="name", property="releasecat.name")
    private String name;
    private final IoCheckedScalar<Repo> githubRepo;

    public Upload() {
        this.githubRepo = new IoCheckedScalar(() -> new RtGithub(this.token).repos().get((Coordinates)new Coordinates.Simple(this.user, this.repo)));
    }

    Upload(String tag, String name, Scalar<Repo> repo) {
        this.tag = tag;
        this.name = name;
        this.githubRepo = new IoCheckedScalar(repo);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("Creating release with name %s and tag %s at %s/%s", this.name, this.tag, this.user, this.repo));
        try {
            new Release.Smart(((Repo)this.githubRepo.value()).releases().create(this.tag)).name(this.name);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Error creating release", (Throwable)e);
        }
    }
}

