/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.mvn.plgn.releasecat;

import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.Repo;
import com.jcabi.github.RtGithub;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.Scalar;
import org.cactoos.scalar.IoCheckedScalar;
import org.cactoos.text.TextOf;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public final class Upload
extends AbstractMojo {
    @Parameter(name="token", property="releasecat.token")
    private String token;
    @Parameter(name="user", property="releasecat.user")
    private String user;
    @Parameter(name="repo", property="releasecat.repo")
    private String repo;
    @Parameter(name="tag", property="releasecat.tag")
    private String tag;
    @Parameter(name="name", property="releasecat.name")
    private String name;
    @Parameter(name="description", property="releasecat.description")
    private String description;
    @Parameter(name="descriptionFromFile", property="releasecat.descriptionFromFile")
    private File descriptionFromFile;
    @Parameter(name="prerelease", property="releasecat.prerelease", defaultValue="false")
    private boolean prerelease;
    private final IoCheckedScalar<Repo> githubRepo;

    public Upload() {
        this.githubRepo = new IoCheckedScalar(() -> new RtGithub(this.token).repos().get((Coordinates)new Coordinates.Simple(this.user, this.repo)));
    }

    Upload(String tag, String name, Scalar<Repo> repo) {
        this(tag, name, "", repo);
    }

    Upload(String tag, String name, String description, Scalar<Repo> repo) {
        this(tag, name, description, false, repo);
    }

    Upload(String tag, String name, String description, boolean prerelease, Scalar<Repo> repo) {
        this.tag = tag;
        this.name = name;
        this.description = description;
        this.prerelease = prerelease;
        this.githubRepo = new IoCheckedScalar(repo);
    }

    Upload(String tag, String name, String description, File descriptionFile, boolean prerelease, Scalar<Repo> repo) {
        this.tag = tag;
        this.name = name;
        this.description = description;
        this.descriptionFromFile = descriptionFile;
        this.prerelease = prerelease;
        this.githubRepo = new IoCheckedScalar(repo);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("Creating release with name %s and tag %s at %s/%s", this.name, this.tag, this.user, this.repo));
        try {
            Release.Smart release = new Release.Smart(((Repo)this.githubRepo.value()).releases().create(this.tag));
            release.name(this.name);
            if (Objects.nonNull(this.description)) {
                release.body(this.description);
            } else if (Objects.nonNull(this.descriptionFromFile)) {
                release.body(new TextOf(this.descriptionFromFile).asString());
            }
            release.prerelease(this.prerelease);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Error creating release", (Throwable)e);
        }
    }
}

