/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.mvn.plgn.releasecat;

import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.Repo;
import com.jcabi.github.RtGithub;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.Scalar;
import org.cactoos.io.BytesOf;
import org.cactoos.scalar.IoCheckedScalar;
import org.cactoos.text.TextOf;
import org.llorllale.mvn.plgn.releasecat.Asset;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public final class Upload
extends AbstractMojo {
    @Parameter(name="token", property="releasecat.token", required=true)
    private String token;
    @Parameter(name="user", property="releasecat.user", required=true)
    private String user;
    @Parameter(name="repo", property="releasecat.repo", required=true)
    private String repo;
    @Parameter(name="tag", property="releasecat.tag", required=true)
    private String tag;
    @Parameter(name="name", property="releasecat.name")
    private String name;
    @Parameter(name="description", property="releasecat.description")
    private String description;
    @Parameter(name="descriptionFromFile", property="releasecat.descriptionFromFile")
    private File descriptionFromFile;
    @Parameter(name="prerelease", property="releasecat.prerelease", defaultValue="false")
    private boolean prerelease;
    @Parameter(name="assets")
    private List<Asset> assets;
    private final IoCheckedScalar<Repo> githubRepo;

    public Upload() {
        this.githubRepo = new IoCheckedScalar(() -> new RtGithub(this.token).repos().get((Coordinates)new Coordinates.Simple(this.user, this.repo)));
    }

    Upload(String tag, String name, Scalar<Repo> repo) {
        this(tag, name, "", repo);
    }

    Upload(String tag, String name, String description, Scalar<Repo> repo) {
        this(tag, name, description, false, repo);
    }

    Upload(String tag, String name, String description, boolean prerelease, Scalar<Repo> repo) {
        this(tag, name, description, null, prerelease, repo);
    }

    Upload(String tag, String name, String description, File descriptionFile, boolean prerelease, Scalar<Repo> repo) {
        this(tag, name, description, descriptionFile, prerelease, Collections.emptyList(), repo);
    }

    Upload(String tag, String name, String description, File descriptionFile, boolean prerelease, List<Asset> assets, Scalar<Repo> repo) {
        this.tag = tag;
        this.name = name;
        this.description = description;
        this.descriptionFromFile = descriptionFile;
        this.prerelease = prerelease;
        this.assets = assets;
        this.githubRepo = new IoCheckedScalar(repo);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("Creating release with name %s and tag %s at %s/%s", this.name, this.tag, this.user, this.repo));
        try {
            Release.Smart release = new Release.Smart(((Repo)this.githubRepo.value()).releases().create(this.tag));
            if (Objects.nonNull(this.name)) {
                release.name(this.name);
            }
            if (Objects.nonNull(this.description)) {
                release.body(this.description);
            } else if (Objects.nonNull(this.descriptionFromFile)) {
                release.body(new TextOf(this.descriptionFromFile).asString());
            }
            release.prerelease(this.prerelease);
            for (Asset asset : Optional.ofNullable(this.assets).orElse(Collections.emptyList())) {
                release.assets().upload(new BytesOf(asset.getFile()).asBytes(), asset.getType(), asset.getName());
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Error creating release", (Throwable)e);
        }
    }
}

