/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.IssueTimeTracking;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.XmlTimeTrackEntry;
import org.llorllale.youtrack.api.jaxb.WorkItem;
import org.llorllale.youtrack.api.jaxb.WorkItems;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithEntity;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultIssueTimeTracking
implements IssueTimeTracking {
    private final Session session;
    private final Issue issue;
    private final HttpClient httpClient;

    DefaultIssueTimeTracking(Session session, Issue issue, HttpClient httpClient) {
        this.session = session;
        this.issue = issue;
        this.httpClient = httpClient;
    }

    DefaultIssueTimeTracking(Session session, Issue issue) {
        this(session, issue, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Stream<TimeTrackEntry> stream() throws IOException, UnauthorizedException {
        return new HttpEntityAsJaxb<WorkItems>(WorkItems.class).apply(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue.id()).concat("/timetracking/workitem")).build())))).asHttpResponse().getEntity()).getWorkItem().stream().map(e -> new XmlTimeTrackEntry(this.issue, (WorkItem)e));
    }

    @Override
    public IssueTimeTracking create(IssueTimeTracking.EntrySpec spec) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity(spec.asHttpEntity(), (HttpEntityEnclosingRequestBase)new HttpPost(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue.id()).concat("/timetracking/workitem")).build()))))).asHttpResponse();
        return new DefaultIssueTimeTracking(this.session, this.issue);
    }
}

