/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.BasicFieldValue;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.XmlUser;
import org.llorllale.youtrack.api.jaxb.User;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultUsersOfIssue
implements UsersOfIssue {
    private final Session session;
    private final Issue issue;
    private final org.llorllale.youtrack.api.jaxb.Issue jaxbIssue;
    private final Field field;
    private final HttpClient httpClient;

    DefaultUsersOfIssue(Session session, Issue issue, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue, HttpClient httpClient) {
        this.session = session;
        this.issue = issue;
        this.jaxbIssue = jaxbIssue;
        this.field = new BasicField("Assignee", issue.project());
        this.httpClient = httpClient;
    }

    DefaultUsersOfIssue(Session session, Issue issue, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue) {
        this(session, issue, jaxbIssue, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public org.llorllale.youtrack.api.User creator() throws IOException, UnauthorizedException {
        return new XmlUser(this.getJaxbUser(this.jaxbIssue.getField().stream().filter(f -> "reporterName".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst().get()));
    }

    @Override
    public Optional<org.llorllale.youtrack.api.User> updater() throws IOException, UnauthorizedException {
        Optional<String> updaterLoginName = this.jaxbIssue.getField().stream().filter(f -> "updaterName".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst();
        Optional<org.llorllale.youtrack.api.User> updater = updaterLoginName.isPresent() ? Optional.of(new XmlUser(this.getJaxbUser(updaterLoginName.get()))) : Optional.empty();
        return updater;
    }

    @Override
    public Optional<org.llorllale.youtrack.api.User> assignee() throws IOException, UnauthorizedException {
        Optional<String> assigneeLoginName = this.jaxbIssue.getField().stream().filter(f -> this.field.name().equals(f.getName())).map(f -> f.getValue().getValue()).findFirst();
        Optional<org.llorllale.youtrack.api.User> assignee = assigneeLoginName.isPresent() ? Optional.of(new XmlUser(this.getJaxbUser(assigneeLoginName.get()))) : Optional.empty();
        return assignee;
    }

    @Override
    public UsersOfIssue assignTo(org.llorllale.youtrack.api.User user) throws IOException, UnauthorizedException {
        return this.issue().update(this.field, new BasicFieldValue(user.loginName(), this.field)).users();
    }

    private User getJaxbUser(String loginName) throws IOException, UnauthorizedException {
        return new HttpEntityAsJaxb<User>(User.class).apply(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/user/").concat(loginName)).build())))).asHttpResponse().getEntity());
    }

    @Override
    public Issue issue() {
        return this.issue;
    }
}

