/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.session.UnauthorizedException;

public interface Issues {
    public Project project();

    public Stream<Issue> stream() throws IOException, UnauthorizedException;

    public Optional<Issue> get(String var1) throws IOException, UnauthorizedException;

    public Issue create(IssueSpec var1) throws IOException, UnauthorizedException;

    public static class IssueSpec {
        private final String summary;
        private final String description;
        private final Map<Field, FieldValue> fields;

        private IssueSpec(String summary, String description, Map<Field, FieldValue> fields) {
            this.summary = summary;
            this.description = description;
            this.fields = fields;
        }

        public IssueSpec(String summary, String description) {
            this(summary, description, new HashMap<Field, FieldValue>());
        }

        public IssueSpec with(Field field, FieldValue value) {
            this.fields.put(field, value);
            return new IssueSpec(this.summary, this.description, this.fields);
        }

        public List<NameValuePair> asNameValuePairs() {
            return Arrays.asList(new BasicNameValuePair("summary", this.summary), new BasicNameValuePair("description", this.description));
        }

        public Map<Field, FieldValue> asFields() {
            return Collections.unmodifiableMap(this.fields);
        }
    }
}

