/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.llorllale.youtrack.api.AssignedField;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.Comments;
import org.llorllale.youtrack.api.DefaultAssignedField;
import org.llorllale.youtrack.api.DefaultComments;
import org.llorllale.youtrack.api.DefaultIssueTimeTracking;
import org.llorllale.youtrack.api.DefaultUsersOfIssue;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.IssueTimeTracking;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpRequestWithEntity;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class XmlIssue
implements Issue {
    private final Project project;
    private final Session session;
    private final org.llorllale.youtrack.api.jaxb.Issue jaxbIssue;
    private final HttpClient httpClient;

    XmlIssue(Project project, Session session, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue, HttpClient httpClient) {
        this.project = project;
        this.session = session;
        this.jaxbIssue = jaxbIssue;
        this.httpClient = httpClient;
    }

    XmlIssue(Project project, Session session, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue) {
        this(project, session, jaxbIssue, (HttpClient)HttpClients.createDefault());
    }

    XmlIssue(XmlIssue prototype) {
        this(prototype.project(), prototype.session, prototype.jaxbIssue);
    }

    @Override
    public String id() {
        return this.jaxbIssue.getId();
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(this.jaxbIssue.getField().stream().filter(f -> "created".equals(f.getName())).map(f -> f.getValue().getValue()).map(Long::valueOf).findFirst().get());
    }

    @Override
    public String summary() {
        return this.jaxbIssue.getField().stream().filter(f -> "summary".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst().get();
    }

    @Override
    public String description() {
        return this.jaxbIssue.getField().stream().filter(f -> "description".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst().get();
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Comments comments() {
        return new DefaultComments(this.session, this);
    }

    @Override
    public IssueTimeTracking timetracking() {
        return new DefaultIssueTimeTracking(this.session, this);
    }

    @Override
    public UsersOfIssue users() {
        return new DefaultUsersOfIssue(this.session, this, this.jaxbIssue);
    }

    @Override
    public Issue refresh() throws IOException, UnauthorizedException {
        return this.project().issues().get(this.id()).get();
    }

    @Override
    public Issue update(Field field, FieldValue value) throws IOException, UnauthorizedException {
        return this.update(String.join((CharSequence)" ", field.name(), value.asString()));
    }

    @Override
    public Issue update(Map<Field, FieldValue> fields) throws IOException, UnauthorizedException {
        return this.update(fields.entrySet().stream().map(e -> String.join((CharSequence)" ", ((Field)e.getKey()).name(), ((FieldValue)e.getValue()).asString())).collect(Collectors.joining(" ")));
    }

    private Issue update(String commands) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("command", commands)), StandardCharsets.UTF_8), (HttpEntityEnclosingRequestBase)new HttpPost(this.session.baseUrl().toString().concat("/issue/").concat(this.id()).concat("/execute")))))).asHttpResponse();
        return this.refresh();
    }

    @Override
    public List<AssignedField> fields() {
        return this.jaxbIssue.getField().stream().filter(f -> Objects.nonNull(f.getValueId())).map(f -> new DefaultAssignedField(new BasicField(f.getName(), this.project), this, (org.llorllale.youtrack.api.jaxb.Field)f)).collect(Collectors.toList());
    }
}

