/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.util.Objects;
import java.util.Optional;
import org.llorllale.youtrack.api.DefaultFields;
import org.llorllale.youtrack.api.DefaultIssues;
import org.llorllale.youtrack.api.DefaultTimeTracking;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.TimeTracking;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.jaxb.Project;
import org.llorllale.youtrack.api.session.Session;

class XmlProject
implements org.llorllale.youtrack.api.Project {
    private final YouTrack youtrack;
    private final Session session;
    private final Project jaxbProject;

    XmlProject(YouTrack youtrack, Session session, Project jaxbProject) {
        this.youtrack = youtrack;
        this.session = session;
        this.jaxbProject = jaxbProject;
    }

    @Override
    public String id() {
        return Optional.ofNullable(this.jaxbProject.getShortName()).orElse(this.jaxbProject.getId());
    }

    @Override
    public String name() {
        return this.jaxbProject.getName();
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.jaxbProject.getDescription());
    }

    @Override
    public Issues issues() {
        return new DefaultIssues(this, this.session);
    }

    @Override
    public YouTrack youtrack() {
        return this.youtrack;
    }

    @Override
    public Fields fields() {
        return new DefaultFields(this.session, this);
    }

    @Override
    public TimeTracking timetracking() {
        return new DefaultTimeTracking(this, this.session);
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!org.llorllale.youtrack.api.Project.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        org.llorllale.youtrack.api.Project other = (org.llorllale.youtrack.api.Project)obj;
        return Objects.equals(this.id(), other.id());
    }
}

