/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.util;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.llorllale.youtrack.api.util.ExceptionalFunction;
import org.llorllale.youtrack.api.util.response.ParseException;

public class XmlStringAsJaxb<T>
implements ExceptionalFunction<String, T, ParseException> {
    private final Class<T> rootType;

    public XmlStringAsJaxb(Class<T> rootType) {
        this.rootType = rootType;
    }

    @Override
    public T apply(String xml) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.rootType});
            Unmarshaller um = ctx.createUnmarshaller();
            return (T)um.unmarshal((Source)new StreamSource(new StringReader(xml)), this.rootType).getValue();
        }
        catch (JAXBException e) {
            throw new ParseException(String.format("Error parsing xml: rootType=%s xml=%s", this.rootType, xml), e);
        }
    }
}

