/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.util.response;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.http.HttpResponse;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.ApplyIf;
import org.llorllale.youtrack.api.util.ExceptionalFunction;
import org.llorllale.youtrack.api.util.InputStreamAsString;
import org.llorllale.youtrack.api.util.response.BadRequest;
import org.llorllale.youtrack.api.util.response.ForbiddenResponse;
import org.llorllale.youtrack.api.util.response.IdentityResponse;
import org.llorllale.youtrack.api.util.response.InternalServerErrorResponse;
import org.llorllale.youtrack.api.util.response.Response;
import org.llorllale.youtrack.api.util.response.UnauthorizedResponse;

public class HttpResponseAsResponse
implements Response {
    private final Response base;

    public HttpResponseAsResponse(HttpResponse httpResponse) {
        this.base = new UnauthorizedResponse(new ForbiddenResponse(new InternalServerErrorResponse(new BadRequest(new IdentityResponse(httpResponse)))));
    }

    @Override
    public HttpResponse asHttpResponse() throws UnauthorizedException, IOException {
        return this.base.asHttpResponse();
    }

    public <R, E extends Exception> Optional<R> applyOnEntity(ExceptionalFunction<String, R, E> function, Predicate<String> condition) throws IOException, UnauthorizedException, E {
        Object result = Objects.nonNull(this.asHttpResponse().getEntity()) ? new ApplyIf<String, R, E>(condition, function).apply((Object)new InputStreamAsString(this.asHttpResponse().getEntity().getContent()).string()) : Optional.empty();
        return result;
    }
}

