/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Comment;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.XmlComment;
import org.llorllale.youtrack.api.jaxb.Comments;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithEntity;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultComments
implements org.llorllale.youtrack.api.Comments {
    private final Session session;
    private final Issue issue;
    private final HttpClient httpClient;

    DefaultComments(Session session, Issue issue, HttpClient httpClient) {
        this.session = session;
        this.issue = issue;
        this.httpClient = httpClient;
    }

    DefaultComments(Session session, Issue issue) {
        this(session, issue, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Stream<Comment> stream() throws IOException, UnauthorizedException {
        return new HttpEntityAsJaxb<Comments>(Comments.class).apply(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue().id()).concat("/comment")).build())))).asHttpResponse().getEntity()).getComment().stream().map(c -> new XmlComment(this.issue(), this.session, (org.llorllale.youtrack.api.jaxb.Comment)c));
    }

    @Override
    public org.llorllale.youtrack.api.Comments post(String text) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new StringEntity("comment=".concat(text), ContentType.APPLICATION_FORM_URLENCODED), (HttpEntityEnclosingRequestBase)new HttpPost(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue().id()).concat("/execute")).build()))))).asHttpResponse();
        return new DefaultComments(this.session, this.issue());
    }

    @Override
    public Issue issue() {
        return this.issue;
    }
}

