/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.UpdateIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpRequestWithEntity;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultUpdateIssue
implements UpdateIssue {
    private final Issue issue;
    private final Session session;

    DefaultUpdateIssue(Issue issue, Session session) {
        this.issue = issue;
        this.session = session;
    }

    @Override
    public Issue summary(String summary) throws IOException, UnauthorizedException {
        return this.updateSummaryDesc(new Issues.IssueSpec(summary));
    }

    @Override
    public Issue description(String description) throws IOException, UnauthorizedException {
        return this.updateSummaryDesc(new Issues.IssueSpec(this.issue.summary(), description));
    }

    @Override
    public Issue summaryAndDesc(String summary, String description) throws IOException, UnauthorizedException {
        return this.updateSummaryDesc(new Issues.IssueSpec(summary, description));
    }

    @Override
    public Issue field(Field field, FieldValue value) throws IOException, UnauthorizedException {
        return this.updateFields(new Issues.IssueSpec(this.issue.summary(), this.issue.description()).with(field, value));
    }

    @Override
    public Issue fields(Map<Field, FieldValue> fields) throws IOException, UnauthorizedException {
        Issues.IssueSpec spec = new Issues.IssueSpec(this.issue.summary(), this.issue.description());
        fields.forEach(spec::with);
        return this.updateFields(spec);
    }

    private Issue updateSummaryDesc(Issues.IssueSpec spec) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpEntityEnclosingRequestBase)new HttpPost(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue.id())).addParameters(spec.asNameValuePairs()).build())))).asHttpResponse();
        return this.issue.refresh();
    }

    private Issue updateFields(Issues.IssueSpec spec) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("command", spec.asFields().entrySet().stream().map(e -> String.join((CharSequence)" ", ((Field)e.getKey()).name(), ((FieldValue)e.getValue()).asString())).collect(Collectors.joining(" ")))), StandardCharsets.UTF_8), (HttpEntityEnclosingRequestBase)new HttpPost(this.session.baseUrl().toString().concat("/issue/").concat(this.issue.id()).concat("/execute")))))).asHttpResponse();
        return this.issue.refresh();
    }
}

