/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Instant;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Comment;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpRequestWithEntity;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class XmlComment
implements Comment {
    private final String id;
    private final long creationDate;
    private final String text;
    private final Issue issue;
    private final Session session;

    XmlComment(String id, long creationDate, String text, Issue issue, Session session) {
        this.id = id;
        this.creationDate = creationDate;
        this.text = text;
        this.issue = issue;
        this.session = session;
    }

    XmlComment(Issue issue, Session session, org.llorllale.youtrack.api.jaxb.Comment jaxbComment) {
        this(jaxbComment.getId(), jaxbComment.getCreated(), jaxbComment.getText(), issue, session);
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(this.creationDate);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public Comment update(String text) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new StringEntity(String.format("{\"text\": \"%s\"}", text), ContentType.APPLICATION_JSON), (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/").concat(this.issue().id()).concat("/comment/").concat(this.id())).build()))))).asHttpResponse();
        return new XmlComment(this.id, this.creationDate, text, this.issue(), this.session);
    }

    @Override
    public Issue delete() throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpDelete(this.session.baseUrl().toString().concat("/issue/").concat(this.issue.id()).concat("/comment/").concat(this.id()))))).asHttpResponse();
        return this.issue();
    }
}

