/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.session;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.llorllale.youtrack.api.session.AuthenticationException;
import org.llorllale.youtrack.api.session.DefaultSession;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;

public class UsernamePasswordLogin
implements Login {
    private final URL youtrackUrl;
    private final HttpClient httpClient;
    private String username;
    private char[] password;

    public UsernamePasswordLogin(URL youtrackUrl, String username, char[] password, HttpClient httpClient) {
        this.youtrackUrl = youtrackUrl;
        this.httpClient = httpClient;
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
    }

    public UsernamePasswordLogin(URL youtrackUrl, String username, char[] password) {
        this(youtrackUrl, username, password, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public final Session login() throws AuthenticationException, IOException {
        if (Objects.isNull(this.username)) {
            throw new IllegalStateException(this.getClass().getSimpleName().concat(".login() cannot be called more than once."));
        }
        URI uri = new UncheckedUriBuilder(this.youtrackUrl.toString().concat("/user/login")).setParameter("login", this.username).setParameter("password", new String(this.password)).build();
        this.username = null;
        this.password = null;
        HttpPost post = new HttpPost(uri);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AuthenticationException("Invalid credentials.");
        }
        Header cookie = (Header)Arrays.asList(response.getAllHeaders()).stream().filter(h -> "Set-Cookie".equals(h.getName())).map(h -> new BasicHeader("Cookie", h.getValue().split(";")[0])).reduce((h1, h2) -> new BasicHeader("Cookie", h1.getValue().concat("; ").concat(h2.getValue()))).get();
        return new DefaultSession(this.youtrackUrl, cookie);
    }
}

