/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class UncheckedUriBuilder {
    private final URIBuilder builder;

    public UncheckedUriBuilder(String baseUrl) {
        try {
            this.builder = new URIBuilder(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("This should not have happened: syntax issue with URL", e);
        }
    }

    public UncheckedUriBuilder setParameter(String name, String value) {
        this.builder.setParameter(name, value);
        return this;
    }

    public UncheckedUriBuilder addParameters(List<NameValuePair> params) {
        this.builder.addParameters(params);
        return this;
    }

    public URI build() {
        try {
            return this.builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("This should not have happened: syntax issue with a URL", e);
        }
    }
}

