/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectField;
import org.llorllale.youtrack.api.XmlProjectField;
import org.llorllale.youtrack.api.jaxb.ProjectCustomField;
import org.llorllale.youtrack.api.jaxb.ProjectCustomFieldRefs;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultFields
implements Fields {
    private final Session session;
    private final Project project;
    private final HttpClient httpClient;

    DefaultFields(Session session, Project project) {
        this.session = session;
        this.project = project;
        this.httpClient = HttpClients.createDefault();
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Stream<ProjectField> stream() throws IOException, UnauthorizedException {
        return new HttpEntityAsJaxb<ProjectCustomFieldRefs>(ProjectCustomFieldRefs.class).apply(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/admin/project/").concat(this.project().id()).concat("/customfield"))))).httpResponse().getEntity()).getProjectCustomField().stream().map(f -> new XmlProjectField((ProjectCustomField)f, this.project(), this.session));
    }
}

