/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.BasicFieldValue;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.User;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.ApplyIf;

class DefaultUsersOfIssue
implements UsersOfIssue {
    private final Issue issue;
    private final org.llorllale.youtrack.api.jaxb.Issue jaxbIssue;
    private final Field field;

    DefaultUsersOfIssue(Issue issue, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue) {
        this.issue = issue;
        this.jaxbIssue = jaxbIssue;
        this.field = new BasicField("Assignee", issue.project());
    }

    @Override
    public User creator() throws IOException, UnauthorizedException {
        return this.issue().project().users().user(this.jaxbIssue.getField().stream().filter(f -> "reporterName".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst().get());
    }

    @Override
    public Optional<User> updater() throws IOException, UnauthorizedException {
        Optional<String> updaterLogin = this.jaxbIssue.getField().stream().filter(f -> "updaterName".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst();
        return new ApplyIf(login -> login.isPresent(), login -> this.issue().project().users().user((String)login.get())).apply(updaterLogin);
    }

    @Override
    public Optional<User> assignee() throws IOException, UnauthorizedException {
        Optional<String> assigneeLogin = this.jaxbIssue.getField().stream().filter(f -> this.field.name().equals(f.getName())).map(f -> f.getValue().getValue()).findFirst();
        return new ApplyIf(login -> login.isPresent(), login -> this.issue().project().users().user((String)login.get())).apply(assigneeLogin);
    }

    @Override
    public UsersOfIssue assignTo(User user) throws IOException, UnauthorizedException {
        return this.issue().update().field(this.field, new BasicFieldValue(user.loginName(), this.field)).users();
    }

    @Override
    public Issue issue() {
        return this.issue;
    }
}

