/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import com.jamesmurty.utils.XMLBuilder2;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.session.UnauthorizedException;

public interface IssueTimeTracking {
    public Stream<TimeTrackEntry> stream() throws IOException, UnauthorizedException;

    public IssueTimeTracking create(EntrySpec var1) throws IOException, UnauthorizedException;

    public static class EntrySpec {
        private final LocalDate date;
        private final Duration duration;
        private final Optional<String> description;
        private final Optional<TimeTrackEntryType> type;

        public EntrySpec(LocalDate date, Duration duration, Optional<String> description, Optional<TimeTrackEntryType> type) {
            this.date = date;
            this.duration = duration;
            this.description = description;
            this.type = type;
        }

        public EntrySpec(Duration duration) {
            this(LocalDate.now(), duration, Optional.empty(), Optional.empty());
        }

        public EntrySpec withDate(LocalDate entryDate) {
            return new EntrySpec(entryDate, this.duration, this.description, this.type);
        }

        public EntrySpec withDesc(String desc) {
            return new EntrySpec(this.date, this.duration, Optional.of(desc), this.type);
        }

        public EntrySpec withType(TimeTrackEntryType entryType) {
            return new EntrySpec(this.date, this.duration, this.description, Optional.of(entryType));
        }

        public HttpEntity asHttpEntity() {
            XMLBuilder2 builder = XMLBuilder2.create((String)"workItem").elem("date").text(String.valueOf(this.date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())).up().elem("duration").text(String.valueOf(this.duration.toMinutes())).up().elem("description").text(this.description.orElse("")).up();
            this.type.ifPresent(t -> builder.elem("worktype").elem("name").text(t.asString()).up().up());
            return new StringEntity(builder.asString(), ContentType.APPLICATION_XML);
        }
    }
}

