/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Projects;
import org.llorllale.youtrack.api.XmlProject;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.jaxb.Project;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.StandardErrorCheck;
import org.llorllale.youtrack.api.util.XmlStringAsJaxb;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultProjects
implements Projects {
    private final YouTrack youtrack;
    private final Session session;
    private final HttpClient httpClient;

    DefaultProjects(YouTrack youtrack, Session session, HttpClient httpClient) {
        this.youtrack = youtrack;
        this.session = session;
        this.httpClient = httpClient;
    }

    DefaultProjects(YouTrack youtrack, Session session) {
        this(youtrack, session, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Stream<org.llorllale.youtrack.api.Project> stream() throws IOException, UnauthorizedException {
        return new HttpEntityAsJaxb<org.llorllale.youtrack.api.jaxb.Projects>(org.llorllale.youtrack.api.jaxb.Projects.class).apply(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/project/all"))))).httpResponse().getEntity()).getProject().stream().map(p -> new XmlProject(this.youtrack, this.session, (Project)p));
    }

    @Override
    public Optional<org.llorllale.youtrack.api.Project> get(String id) throws IOException, UnauthorizedException {
        return new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/admin/project/").concat(id))))).applyOnEntity(new XmlStringAsJaxb<Project>(Project.class), new StandardErrorCheck()).map(p -> new XmlProject(this.youtrack, this.session, (Project)p));
    }
}

