/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.util;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.util.ExceptionalFunction;
import org.llorllale.youtrack.api.util.UncheckedException;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

public final class Page<T>
implements Iterator<T> {
    private final HttpUriRequest request;
    private final ExceptionalFunction<HttpEntity, Collection<T>, IOException> mapper;
    private final Deque<T> contents;

    public Page(HttpUriRequest request, ExceptionalFunction<HttpEntity, Collection<T>, IOException> mapper) {
        this.request = request;
        this.mapper = mapper;
        this.contents = new ArrayDeque<T>();
    }

    @Override
    public boolean hasNext() {
        if (this.contents.isEmpty()) {
            try {
                this.contents.addAll(this.mapper.apply(new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute(this.request)).httpResponse().getEntity()));
            }
            catch (IOException e) {
                throw new UncheckedException(e);
            }
        }
        return !this.contents.isEmpty();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.contents.pop();
        }
        throw new NoSuchElementException();
    }

    public static final class Empty<T>
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    }
}

