/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.XmlIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;
import org.llorllale.youtrack.api.util.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.util.HttpRequestWithSession;
import org.llorllale.youtrack.api.util.MapIfNoError;
import org.llorllale.youtrack.api.util.MapIfPresent;
import org.llorllale.youtrack.api.util.Pagination;
import org.llorllale.youtrack.api.util.StreamOf;
import org.llorllale.youtrack.api.util.UncheckedUriBuilder;
import org.llorllale.youtrack.api.util.XmlStringAsJaxb;
import org.llorllale.youtrack.api.util.response.HttpResponseAsResponse;

class DefaultIssues
implements Issues {
    private final Project project;
    private final Session session;
    private final HttpClient httpClient;

    DefaultIssues(Project project, Session session, HttpClient httpClient) {
        this.project = project;
        this.session = session;
        this.httpClient = httpClient;
    }

    DefaultIssues(Project project, Session session) {
        this(project, session, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Stream<Issue> stream() throws IOException, UnauthorizedException {
        int pageSize = 10;
        return new StreamOf<Issue>(new Pagination(10, n -> new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/byproject/").concat(this.project().id())).setParameter("after", String.valueOf(n)).build())), new HttpEntityAsJaxb<org.llorllale.youtrack.api.jaxb.Issues>(org.llorllale.youtrack.api.jaxb.Issues.class).andThen(issues -> issues.getIssue().stream().map(issue -> new XmlIssue(this.project(), this.session, (org.llorllale.youtrack.api.jaxb.Issue)issue)).collect(Collectors.toList()))));
    }

    @Override
    public Optional<Issue> get(String issueId) throws IOException, UnauthorizedException {
        return new MapIfPresent<org.llorllale.youtrack.api.jaxb.Issue, Issue>(new MapIfNoError<org.llorllale.youtrack.api.jaxb.Issue>(new MapIfPresent<HttpEntity, HttpEntity>(() -> Optional.ofNullable(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/issue/").concat(issueId))))).httpResponse().getEntity()), e -> e), s -> new XmlStringAsJaxb<org.llorllale.youtrack.api.jaxb.Issue>(org.llorllale.youtrack.api.jaxb.Issue.class).apply((String)s)), issue -> new XmlIssue(this.project(), this.session, (org.llorllale.youtrack.api.jaxb.Issue)issue)).get();
    }

    @Override
    public Issue create(Issues.IssueSpec spec) throws IOException, UnauthorizedException {
        return this.get(StringUtils.substringAfterLast((String)new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue")).setParameter("project", this.project().id()).addParameters(spec.nameValuePairs()).build())))).httpResponse().getFirstHeader("Location").getValue(), (String)"/")).get().update().fields(spec.fields());
    }
}

