/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.XmlTimeTrackEntryType;
import org.llorllale.youtrack.api.jaxb.WorkItem;

class XmlTimeTrackEntry
implements TimeTrackEntry {
    private final Issue issue;
    private final WorkItem jaxbWorkItem;

    XmlTimeTrackEntry(Issue issue, WorkItem jaxbWorkItem) {
        this.issue = issue;
        this.jaxbWorkItem = jaxbWorkItem;
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    @Override
    public LocalDate date() {
        return Instant.ofEpochMilli(this.jaxbWorkItem.getDate()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public Duration duration() {
        return Duration.ofMinutes(this.jaxbWorkItem.getDuration());
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.jaxbWorkItem.getDescription());
    }

    @Override
    public Optional<TimeTrackEntryType> type() {
        return Optional.ofNullable(this.jaxbWorkItem.getWorkType()).map(XmlTimeTrackEntryType::new);
    }
}

