/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.util;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.http.HttpEntity;
import org.llorllale.youtrack.api.util.ExceptionalFunction;
import org.llorllale.youtrack.api.util.ExceptionalSupplier;
import org.llorllale.youtrack.api.util.InputStreamAsString;
import org.llorllale.youtrack.api.util.StandardErrorCheck;

public final class MapIfNoError<R>
implements ExceptionalSupplier<Optional<R>, IOException> {
    private final ExceptionalSupplier<Optional<HttpEntity>, IOException> supplier;
    private final ExceptionalFunction<String, R, IOException> mappingFunction;
    private final Predicate<String> condition;

    public MapIfNoError(ExceptionalSupplier<Optional<HttpEntity>, IOException> supplier, ExceptionalFunction<String, R, IOException> mappingFunction) {
        this.supplier = supplier;
        this.mappingFunction = mappingFunction;
        this.condition = new StandardErrorCheck();
    }

    @Override
    public Optional<R> get() throws IOException {
        String xml;
        Optional<HttpEntity> entity = this.supplier.get();
        Optional<Object> result = entity.isPresent() ? (this.condition.test(xml = new InputStreamAsString().apply(entity.get().getContent())) ? Optional.of(this.mappingFunction.apply(xml)) : Optional.empty()) : Optional.empty();
        return result;
    }
}

