/* 
 * Copyright 2017 George Aristy (george.aristy@gmail.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.llorllale.youtrack.api;

import java.io.IOException;

import org.apache.http.HttpResponse;

import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

/**
 * Handles HTTP response status codes received from the YouTrack server.
 * 
 * @author George Aristy (george.aristy@gmail.com)
 * @since 0.1.0
 */
interface Response {
  /**
   * The {@link HttpResponse} received in the API's response.
   * 
   * @return The httpResponse received in the API's response.
   * @throws IOException if the server is unavailable
   * @throws UnauthorizedException if the user's {@link Session} is unauthorized to perform some
   *     operation
   * @since 0.1.0
   */
  HttpResponse httpResponse() throws IOException, UnauthorizedException;
}
