/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Mapping;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.XmlTimeTrackEntryType;
import org.llorllale.youtrack.api.jaxb.Settings;
import org.llorllale.youtrack.api.jaxb.WorkItemTypes;
import org.llorllale.youtrack.api.jaxb.WorkType;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class DefaultProjectTimeTracking
implements ProjectTimeTracking {
    private static final String PATH_TEMPLATE = "/admin/project/%s/timetracking";
    private final Project project;
    private final Session session;

    DefaultProjectTimeTracking(Project project, Session session) {
        this.project = project;
        this.session = session;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public boolean enabled() throws IOException, UnauthorizedException {
        Settings settings = new Mapping<HttpResponseAsResponse, Settings>(() -> new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id())))))), resp -> new HttpEntityAsJaxb<Settings>(Settings.class).apply(resp.httpResponse().getEntity())).get();
        return settings.isEnabled() != false && Objects.nonNull(settings.getEstimation()) && Objects.nonNull(settings.getSpentTime());
    }

    @Override
    public Stream<TimeTrackEntryType> types() throws IOException, UnauthorizedException {
        return new StreamOf<TimeTrackEntryType>(new MappedCollection<WorkType, TimeTrackEntryType>(new Mapping<HttpResponseAsResponse, Collection>(() -> new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id())).concat("/worktype"))))), resp -> new HttpEntityAsJaxb<WorkItemTypes>(WorkItemTypes.class).apply(resp.httpResponse().getEntity()).getWorkType()), XmlTimeTrackEntryType::new));
    }
}

