/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.llorllale.youtrack.api.AssignedField;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.Comments;
import org.llorllale.youtrack.api.DefaultAssignedField;
import org.llorllale.youtrack.api.DefaultComments;
import org.llorllale.youtrack.api.DefaultIssueTimeTracking;
import org.llorllale.youtrack.api.DefaultUpdateIssue;
import org.llorllale.youtrack.api.DefaultUsersOfIssue;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.IssueTimeTracking;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.UpdateIssue;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class XmlIssue
implements Issue {
    private final Project project;
    private final Session session;
    private final org.llorllale.youtrack.api.jaxb.Issue jaxbIssue;

    XmlIssue(Project project, Session session, org.llorllale.youtrack.api.jaxb.Issue jaxbIssue) {
        this.project = project;
        this.session = session;
        this.jaxbIssue = jaxbIssue;
    }

    XmlIssue(XmlIssue prototype) {
        this(prototype.project(), prototype.session, prototype.jaxbIssue);
    }

    @Override
    public String id() {
        return this.jaxbIssue.getId();
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(this.jaxbIssue.getField().stream().filter(f -> "created".equals(f.getName())).map(f -> f.getValue().getValue()).map(Long::valueOf).findFirst().get());
    }

    @Override
    public String summary() {
        return this.jaxbIssue.getField().stream().filter(f -> "summary".equals(f.getName())).map(f -> f.getValue().getValue()).findFirst().get();
    }

    @Override
    public Optional<String> description() {
        return this.jaxbIssue.getField().stream().filter(f -> "description".equals(f.getName())).map(f -> f.getValue().getValue()).findAny();
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Comments comments() {
        return new DefaultComments(this.session, this);
    }

    @Override
    public IssueTimeTracking timetracking() {
        return new DefaultIssueTimeTracking(this.session, this);
    }

    @Override
    public UsersOfIssue users() {
        return new DefaultUsersOfIssue(this, this.jaxbIssue);
    }

    @Override
    public Issue refresh() throws IOException, UnauthorizedException {
        return this.project().issues().get(this.id()).get();
    }

    @Override
    public UpdateIssue update() {
        return new DefaultUpdateIssue(this, this.session);
    }

    @Override
    public List<AssignedField> fields() {
        return this.jaxbIssue.getField().stream().filter(f -> Objects.nonNull(f.getValueId())).map(f -> new DefaultAssignedField(new BasicField(f.getName(), this.project), this, (org.llorllale.youtrack.api.jaxb.Field)f)).collect(Collectors.toList());
    }

    @Override
    public Issues.IssueSpec spec() {
        Issues.IssueSpec spec = new Issues.IssueSpec(this.summary(), this.description());
        this.fields().forEach(f -> spec.with((Field)f, f.value()));
        return spec;
    }
}

