/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.util.Objects;
import java.util.Optional;
import org.llorllale.youtrack.api.DefaultFields;
import org.llorllale.youtrack.api.DefaultIssues;
import org.llorllale.youtrack.api.DefaultProjectTimeTracking;
import org.llorllale.youtrack.api.DefaultUsersOfProject;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.UsersOfProject;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.jaxb.Project;
import org.llorllale.youtrack.api.session.Session;

class XmlProject
implements org.llorllale.youtrack.api.Project {
    private final YouTrack youtrack;
    private final Session session;
    private final Project jaxbProject;

    XmlProject(YouTrack youtrack, Session session, Project jaxbProject) {
        this.youtrack = youtrack;
        this.session = session;
        this.jaxbProject = jaxbProject;
    }

    @Override
    public String id() {
        return Optional.ofNullable(this.jaxbProject.getShortName()).orElse(this.jaxbProject.getId());
    }

    @Override
    public String name() {
        return this.jaxbProject.getName();
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.jaxbProject.getDescription());
    }

    @Override
    public Issues issues() {
        return new DefaultIssues(this, this.session);
    }

    @Override
    public YouTrack youtrack() {
        return this.youtrack;
    }

    @Override
    public Fields fields() {
        return new DefaultFields(this.session, this);
    }

    @Override
    public ProjectTimeTracking timetracking() {
        return new DefaultProjectTimeTracking(this, this.session);
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof org.llorllale.youtrack.api.Project)) {
            return false;
        }
        org.llorllale.youtrack.api.Project other = (org.llorllale.youtrack.api.Project)obj;
        return Objects.equals(this.id(), other.id());
    }

    @Override
    public UsersOfProject users() {
        return new DefaultUsersOfProject(this, this.session, this.jaxbProject);
    }
}

