/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.HttpEntityAsJaxb;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Mapping;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectField;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.SubstringAfterLast;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.XmlFieldValue;
import org.llorllale.youtrack.api.jaxb.Enumeration;
import org.llorllale.youtrack.api.jaxb.ProjectCustomField;
import org.llorllale.youtrack.api.jaxb.Value;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class XmlProjectField
implements ProjectField {
    private final ProjectCustomField jaxb;
    private final Project project;
    private final Session session;
    private final HttpClient httpClient;

    XmlProjectField(ProjectCustomField jaxb, Project project, Session session) {
        this.jaxb = jaxb;
        this.project = project;
        this.session = session;
        this.httpClient = HttpClients.createDefault();
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public String name() {
        return this.jaxb.getName();
    }

    @Override
    public Stream<FieldValue> values() throws IOException, UnauthorizedException {
        String bundleName = new Mapping<HttpResponseAsResponse, String>(() -> new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/admin/project/").concat(this.project().id()).concat("/customfield/").concat(new SubstringAfterLast(this.jaxb.getUrl(), "/").get()))))), resp -> new HttpEntityAsJaxb<ProjectCustomField>(ProjectCustomField.class).apply(resp.httpResponse().getEntity()).getParam().getValue()).get();
        return new StreamOf<FieldValue>(new MappedCollection<Value, FieldValue>(new Mapping<HttpResponseAsResponse, Collection>(() -> new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl(), "/admin/customfield/bundle/".concat(bundleName)).build())))), resp -> new HttpEntityAsJaxb<Enumeration>(Enumeration.class).apply(resp.httpResponse().getEntity()).getValue()), v -> new XmlFieldValue((Value)v, new XmlProjectField(this.jaxb, this.project, this.session))));
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.name());
        hash = 47 * hash + Objects.hashCode(this.project().id());
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return this.isSameField(other);
    }
}

