/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.llorllale.youtrack.api.ExceptionalFunction;
import org.llorllale.youtrack.api.ParseException;

final class XmlStringAsJaxb<T>
implements ExceptionalFunction<String, T, ParseException> {
    private final Class<T> rootType;

    XmlStringAsJaxb(Class<T> rootType) {
        this.rootType = rootType;
    }

    @Override
    public T apply(String xml) throws ParseException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.rootType});
            return (T)ctx.createUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(xml)), this.rootType).getValue();
        }
        catch (JAXBException e) {
            throw new ParseException(String.format("Error parsing xml: rootType=%s xml=%s", this.rootType, xml), e);
        }
    }
}

