/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.XmlObject;
import org.llorllale.youtrack.api.XmlObjects;
import org.llorllale.youtrack.api.XmlTimeTrackEntryType;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class DefaultProjectTimeTracking
implements ProjectTimeTracking {
    private static final String PATH_TEMPLATE = "/admin/project/%s/timetracking";
    private final Project project;
    private final Session session;
    private final HttpClient httpClient;

    DefaultProjectTimeTracking(Project project, Session session, HttpClient httpClient) {
        this.project = project;
        this.session = session;
        this.httpClient = httpClient;
    }

    DefaultProjectTimeTracking(Project project, Session session) {
        this(project, session, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public boolean enabled() throws IOException, UnauthorizedException {
        XmlObject settings = (XmlObject)new XmlObjects("/settings", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id()))))))).stream().findAny().get();
        return Boolean.parseBoolean(settings.textOf("@enabled").get()) && settings.child("estimation").isPresent() && settings.child("spentTime").isPresent();
    }

    @Override
    public Stream<TimeTrackEntryType> types() throws IOException, UnauthorizedException {
        return new StreamOf<TimeTrackEntryType>(new MappedCollection<XmlObject, TimeTrackEntryType>(XmlTimeTrackEntryType::new, new XmlObjects("/workItemTypes/workType", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id())).concat("/worktype"))))))));
    }
}

