/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import org.llorllale.youtrack.api.AssignedField;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.Comments;
import org.llorllale.youtrack.api.DefaultComments;
import org.llorllale.youtrack.api.DefaultIssueTimeTracking;
import org.llorllale.youtrack.api.DefaultUpdateIssue;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.IssueTimeTracking;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.UpdateIssue;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.XmlAssignedField;
import org.llorllale.youtrack.api.XmlObject;
import org.llorllale.youtrack.api.XmlUsersOfIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class XmlIssue
implements Issue {
    private final Project project;
    private final Session session;
    private final XmlObject xml;

    XmlIssue(Project project, Session session, XmlObject xml) {
        this.project = project;
        this.session = session;
        this.xml = xml;
    }

    @Override
    public String id() {
        return this.xml.textOf("@id").get();
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(Long.parseLong(this.xml.textOf("//field[@name = 'created']/value").get()));
    }

    @Override
    public String summary() {
        return this.xml.textOf("//field[@name = 'summary']/value").get();
    }

    @Override
    public Optional<String> description() {
        return this.xml.textOf("//field[@name = 'description']/value");
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Comments comments() {
        return new DefaultComments(this.session, this);
    }

    @Override
    public IssueTimeTracking timetracking() {
        return new DefaultIssueTimeTracking(this.session, this);
    }

    @Override
    public UsersOfIssue users() {
        return new XmlUsersOfIssue(this, this.xml);
    }

    @Override
    public Issue refresh() throws IOException, UnauthorizedException {
        return this.project().issues().get(this.id()).get();
    }

    @Override
    public UpdateIssue update() {
        return new DefaultUpdateIssue(this, this.session);
    }

    @Override
    public Collection<AssignedField> fields() {
        return new MappedCollection<XmlObject, AssignedField>(x -> new XmlAssignedField(new BasicField(x.textOf("@name").get(), this.project()), this, (XmlObject)x), this.xml.children("//field[count(valueId) > 0]"));
    }

    @Override
    public Issues.IssueSpec spec() {
        Issues.IssueSpec spec = new Issues.IssueSpec(this.summary(), this.description());
        this.fields().forEach(f -> spec.with((Field)f, f.value()));
        return spec;
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)object;
        return this.id().equals(other.id()) && this.project().equals(other.project());
    }
}

