/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Pagination;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.Response;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.SubstringAfterLast;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.XmlIssue;
import org.llorllale.youtrack.api.XmlObject;
import org.llorllale.youtrack.api.XmlObjects;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class DefaultIssues
implements Issues {
    private final Project project;
    private final Session session;
    private final HttpClient httpClient;

    DefaultIssues(Project project, Session session, HttpClient httpClient) {
        this.project = project;
        this.session = session;
        this.httpClient = httpClient;
    }

    DefaultIssues(Project project, Session session) {
        this(project, session, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Stream<Issue> stream() throws IOException, UnauthorizedException {
        int pageSize = 10;
        return new StreamOf<Issue>(new Pagination(10, n -> new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue/byproject/").concat(this.project().id())).param("after", String.valueOf(n)).build())), resp -> new MappedCollection<XmlObject, Issue>(xml -> new XmlIssue(this.project(), this.session, (XmlObject)xml), new XmlObjects("/issues/issue", (Response)resp)), this.httpClient));
    }

    @Override
    public Optional<Issue> get(String issueId) throws IOException, UnauthorizedException {
        XmlObject xml = new XmlObject(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/issue/").concat(issueId))))));
        Optional<Issue> issue = xml.child("//error").isPresent() ? Optional.empty() : Optional.of(new XmlIssue(this.project(), this.session, xml));
        return issue;
    }

    @Override
    public Issue create(Issues.IssueSpec spec) throws IOException, UnauthorizedException {
        return this.get(new SubstringAfterLast(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.session.baseUrl().toString().concat("/issue")).param("project", this.project().id()).param("summary", spec.summary()).paramIfPresent("description", spec.description()).build())))).httpResponse().getFirstHeader("Location").getValue(), "/").get()).get().update().fields(spec.fields());
    }
}

