/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.session.UnauthorizedException;

public interface Issues {
    public Project project();

    public Stream<Issue> stream() throws IOException, UnauthorizedException;

    public Optional<Issue> get(String var1) throws IOException, UnauthorizedException;

    public Issue create(IssueSpec var1) throws IOException, UnauthorizedException;

    public static class IssueSpec {
        private final String summary;
        private final Optional<String> description;
        private final Map<Field, FieldValue> fields;

        private IssueSpec(String summary, Optional<String> description, Map<Field, FieldValue> fields) {
            this.summary = summary;
            this.description = description;
            this.fields = fields;
        }

        IssueSpec(String summary, Optional<String> description) {
            this(summary, description, new HashMap<Field, FieldValue>());
        }

        public IssueSpec(String summary, String description) {
            this(summary, Optional.of(description));
        }

        public IssueSpec(String summary) {
            this(summary, Optional.empty());
        }

        public IssueSpec with(Field field, FieldValue value) {
            this.fields.put(field, value);
            return new IssueSpec(this.summary, this.description, this.fields);
        }

        public String summary() {
            return this.summary;
        }

        public Optional<String> description() {
            return this.description;
        }

        public Map<Field, FieldValue> fields() {
            return Collections.unmodifiableMap(this.fields);
        }

        public boolean equals(Object object) {
            if (!(object instanceof IssueSpec)) {
                return false;
            }
            IssueSpec other = (IssueSpec)object;
            return this.summary().equals(other.summary()) && this.description().equals(other.description()) && this.fields().equals(other.fields());
        }

        public int hashCode() {
            return this.summary().hashCode() + this.description().hashCode() + this.fields().hashCode();
        }
    }
}

