/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.llorllale.youtrack.api.InputStreamAsString;
import org.llorllale.youtrack.api.ParseException;
import org.llorllale.youtrack.api.Response;
import org.llorllale.youtrack.api.StringAsDocument;
import org.llorllale.youtrack.api.UncheckedException;
import org.llorllale.youtrack.api.XmlObjects;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlObject {
    private final Node xml;

    XmlObject(Node xml) {
        this.xml = xml;
    }

    XmlObject(Document document) {
        this(document.getDocumentElement());
    }

    XmlObject(Response response) throws ParseException, IOException {
        this(new StringAsDocument(new InputStreamAsString().apply(response.httpResponse().getEntity().getContent())).getDocumentElement());
    }

    Optional<String> textOf(String xpath) throws UncheckedException {
        return this.child(xpath).map(x -> x.node().getTextContent());
    }

    Optional<XmlObject> child(String xpath) throws UncheckedException {
        return this.children(xpath).stream().findFirst();
    }

    Collection<XmlObject> children(String xpath) throws UncheckedException {
        try {
            return new XmlObjects((NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, this.node(), XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            throw new UncheckedException(e.getMessage(), e);
        }
    }

    private Node node() {
        return this.xml;
    }
}

