/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import java.util.stream.Stream;
import org.llorllale.youtrack.api.StringAsDocument;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlOf;
import org.llorllale.youtrack.api.session.UnauthorizedException;

public interface IssueTimeTracking {
    public Stream<TimeTrackEntry> stream() throws IOException, UnauthorizedException;

    public IssueTimeTracking create(EntrySpec var1) throws IOException, UnauthorizedException;

    public static final class EntrySpec {
        private final LocalDate date;
        private final Duration duration;
        private final String description;
        private final TimeTrackEntryType type;

        public EntrySpec(LocalDate date, Duration duration, String description, TimeTrackEntryType type) {
            this.date = date;
            this.duration = duration;
            this.description = description;
            this.type = type;
        }

        public EntrySpec(Duration duration) {
            this(LocalDate.now(), duration, null, null);
        }

        public EntrySpec(Duration duration, String description) {
            this(LocalDate.now(), duration, description, null);
        }

        public EntrySpec(LocalDate date, Duration duration) {
            this(date, duration, null, null);
        }

        public EntrySpec(Duration duration, TimeTrackEntryType type) {
            this(LocalDate.now(), duration, null, type);
        }

        public EntrySpec(Duration duration, String description, TimeTrackEntryType type) {
            this(LocalDate.now(), duration, description, type);
        }

        public EntrySpec(LocalDate date, Duration duration, String description) {
            this(date, duration, description, null);
        }

        public Xml asXml() {
            StringBuilder xmlBuilder = new StringBuilder("<workItem>").append("<date>").append(String.valueOf(this.date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())).append("</date>").append("<duration>").append(String.valueOf(this.duration.toMinutes())).append("</duration>").append("<description>").append(Optional.ofNullable(this.description).orElse("")).append("</description>");
            Optional.ofNullable(this.type).ifPresent(t -> xmlBuilder.append("<worktype>").append("<name>").append(t.asString()).append("</name>").append("</worktype>"));
            xmlBuilder.append("</workItem>");
            return new XmlOf(new StringAsDocument(xmlBuilder.toString()));
        }

        public int hashCode() {
            return this.duration.hashCode() ^ this.date.hashCode() ^ Optional.ofNullable(this.description).hashCode() ^ Optional.ofNullable(this.type).hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof EntrySpec)) {
                return false;
            }
            EntrySpec other = (EntrySpec)object;
            return this.asXml().node().isEqualNode(other.asXml().node());
        }
    }
}

