/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.session.UnauthorizedException;

public interface Issues {
    public Project project();

    public Stream<Issue> stream() throws IOException, UnauthorizedException;

    public Optional<Issue> get(String var1) throws IOException, UnauthorizedException;

    public Issue create(IssueSpec var1) throws IOException, UnauthorizedException;

    public static final class IssueSpec {
        private final String summary;
        private final String description;
        private final Map<Field, FieldValue> fields;

        public IssueSpec(String summary, String description, Map<Field, FieldValue> fields) {
            this.summary = summary;
            this.description = description;
            this.fields = fields;
        }

        public IssueSpec(String summary, String description) {
            this(summary, description, new HashMap<Field, FieldValue>());
        }

        IssueSpec(String summary, Optional<String> description) {
            this(summary, (String)description.orElse(null));
        }

        IssueSpec(String summary, Optional<String> description, Map<Field, FieldValue> fields) {
            this(summary, (String)description.orElse(null), fields);
        }

        public IssueSpec(String summary, Map<Field, FieldValue> fields) {
            this(summary, (String)null, fields);
        }

        public IssueSpec(String summary) {
            this(summary, new HashMap<Field, FieldValue>());
        }

        public String summary() {
            return this.summary;
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Map<Field, FieldValue> fields() {
            return Collections.unmodifiableMap(this.fields);
        }

        public boolean equals(Object object) {
            if (!(object instanceof IssueSpec)) {
                return false;
            }
            IssueSpec other = (IssueSpec)object;
            return this.summary().equals(other.summary()) && this.description().equals(other.description()) && this.fields().equals(other.fields());
        }

        public int hashCode() {
            return this.summary().hashCode() + this.description().hashCode() + this.fields().hashCode();
        }
    }
}

