/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api.session;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.session.AuthenticationException;
import org.llorllale.youtrack.api.session.Cookie;
import org.llorllale.youtrack.api.session.DefaultCookie;
import org.llorllale.youtrack.api.session.DefaultSession;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.Session;

public final class UsernamePasswordLogin
implements Login {
    private final URL youtrackUrl;
    private final HttpClient httpClient;
    private String username;
    private char[] password;

    UsernamePasswordLogin(URL youtrackUrl, String username, char[] password, HttpClient httpClient) {
        this.youtrackUrl = youtrackUrl;
        this.httpClient = httpClient;
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
    }

    public UsernamePasswordLogin(URL youtrackUrl, String username, char[] password) {
        this(youtrackUrl, username, password, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Session login() throws AuthenticationException, IOException {
        try {
            URI uri = new URIBuilder(this.youtrackUrl.toString().concat("/user/login")).setParameter("login", this.username).setParameter("password", new String(this.password)).build();
            this.username = null;
            this.password = null;
            HttpPost post = new HttpPost(uri);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new AuthenticationException("Invalid credentials.");
            }
            String cookieHeader = "Cookie";
            Cookie cookie = Arrays.asList(response.getAllHeaders()).stream().filter(header -> "Set-Cookie".equals(header.getName())).map(header -> new DefaultCookie("Cookie", header.getValue().split(";")[0])).reduce((cookieA, cookieB) -> new DefaultCookie("Cookie", cookieA.value().concat("; ").concat(cookieB.value()))).get();
            return new DefaultSession(this.youtrackUrl, cookie);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }
}

