/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlTimeTrackEntryType;

class XmlTimeTrackEntry
implements TimeTrackEntry {
    private final Issue issue;
    private final Xml xml;

    XmlTimeTrackEntry(Issue issue, Xml xml) {
        this.issue = issue;
        this.xml = xml;
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    @Override
    public LocalDate date() {
        return Instant.ofEpochMilli(Long.parseLong(this.xml.textOf("date").get())).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public Duration duration() {
        return Duration.ofMinutes(Long.parseLong(this.xml.textOf("duration").get()));
    }

    @Override
    public Optional<String> description() {
        return this.xml.textOf("description");
    }

    @Override
    public Optional<TimeTrackEntryType> type() {
        return this.xml.child("workType").map(XmlTimeTrackEntryType::new);
    }
}

