/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import org.llorllale.youtrack.api.BasicField;
import org.llorllale.youtrack.api.BasicFieldValue;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.User;
import org.llorllale.youtrack.api.UsersOfIssue;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class XmlUsersOfIssue
implements UsersOfIssue {
    private final Issue issue;
    private final Xml xml;

    XmlUsersOfIssue(Issue issue, Xml xml) {
        this.issue = issue;
        this.xml = xml;
    }

    @Override
    public User creator() throws IOException, UnauthorizedException {
        return this.issue().project().users().user(this.xml.textOf("//field[@name = 'reporterName']/value").get());
    }

    @Override
    public Optional<User> updater() throws IOException, UnauthorizedException {
        return this.user(this.xml.textOf("//field[@name = 'updaterName']/value"));
    }

    @Override
    public Optional<User> assignee() throws IOException, UnauthorizedException {
        return this.user(this.xml.textOf("//field[@name = 'Assignee']/value"));
    }

    @Override
    public UsersOfIssue assignTo(User user) throws IOException, UnauthorizedException {
        BasicField field = new BasicField("Assignee", this.issue().project());
        return this.issue().update().field(field, new BasicFieldValue(user.loginName(), field)).users();
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    private Optional<User> user(Optional<String> login) throws UnauthorizedException, IOException {
        Optional<User> user = login.isPresent() ? Optional.of(this.issue().project().users().user(login.get())) : Optional.empty();
        return user;
    }
}

