/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpRequestWithEntity;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.IssueTimeTracking;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.TimeTrackEntry;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlTimeTrackEntry;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class DefaultIssueTimeTracking
implements IssueTimeTracking {
    private static final String PATH_TEMPLATE = "/issue/%s/timetracking/workitem";
    private final Session session;
    private final Issue issue;
    private final HttpClient httpClient;

    DefaultIssueTimeTracking(Session session, Issue issue, HttpClient httpClient) {
        this.session = session;
        this.issue = issue;
        this.httpClient = httpClient;
    }

    DefaultIssueTimeTracking(Session session, Issue issue) {
        this(session, issue, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Stream<TimeTrackEntry> stream() throws IOException, UnauthorizedException {
        return new StreamOf<TimeTrackEntry>(new MappedCollection<Xml, TimeTrackEntry>(xml -> new XmlTimeTrackEntry(this.issue, (Xml)xml), new XmlsOf("/workItems/workItem", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue.id())))))))));
    }

    @Override
    public IssueTimeTracking create(Duration duration) throws IOException, UnauthorizedException {
        return this.create(LocalDate.now(), duration, null, null);
    }

    @Override
    public IssueTimeTracking create(Duration duration, String description) throws IOException, UnauthorizedException {
        return this.create(LocalDate.now(), duration, description, null);
    }

    @Override
    public IssueTimeTracking create(LocalDate date, Duration duration) throws IOException, UnauthorizedException {
        return this.create(date, duration, null, null);
    }

    @Override
    public IssueTimeTracking create(Duration duration, TimeTrackEntryType type) throws IOException, UnauthorizedException {
        return this.create(LocalDate.now(), duration, null, type);
    }

    @Override
    public IssueTimeTracking create(Duration duration, String description, TimeTrackEntryType type) throws IOException, UnauthorizedException {
        return this.create(LocalDate.now(), duration, description, type);
    }

    @Override
    public IssueTimeTracking create(LocalDate date, Duration duration, String description) throws IOException, UnauthorizedException {
        return this.create(date, duration, description, null);
    }

    @Override
    public IssueTimeTracking create(LocalDate date, Duration duration, String description, TimeTrackEntryType type) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new StringEntity(this.toXmlString(date, duration, description, type), ContentType.APPLICATION_XML), (HttpEntityEnclosingRequestBase)new HttpPost(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue.id()))))))).httpResponse();
        return new DefaultIssueTimeTracking(this.session, this.issue);
    }

    private String toXmlString(LocalDate date, Duration duration, String description, TimeTrackEntryType type) {
        StringBuilder xmlBuilder = new StringBuilder("<workItem>").append("<date>").append(String.valueOf(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())).append("</date>").append("<duration>").append(String.valueOf(duration.toMinutes())).append("</duration>").append("<description>").append(Optional.ofNullable(description).orElse("")).append("</description>");
        Optional.ofNullable(type).ifPresent(t -> xmlBuilder.append("<worktype>").append("<name>").append(t.asString()).append("</name>").append("</worktype>"));
        xmlBuilder.append("</workItem>");
        return xmlBuilder.toString();
    }
}

